/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.util;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.bgerp.app.exception.BGException;
import org.bgerp.util.Log;

public class RuntimeRunner {
    private static final Log log = Log.getLog();
    private final String[] commands;

    public RuntimeRunner(String ... commands) {
        this.commands = commands;
    }

    public void run() throws IOException, InterruptedException {
        log.info("Running: {}", Lists.newArrayList((Object[])this.commands));
        Process proc = Runtime.getRuntime().exec(this.commands);
        new StreamGobbler(proc.getErrorStream(), (Priority)Level.ERROR).start();
        new StreamGobbler(proc.getInputStream(), (Priority)Level.INFO).start();
        int result = proc.waitFor();
        if (result != 0) {
            throw new BGException("Process exit code: {}", result);
        }
    }

    private static class StreamGobbler
    extends Thread {
        private final InputStream is;
        private final Priority logLevel;

        private StreamGobbler(InputStream is, Priority logLevel) {
            this.is = is;
            this.logLevel = logLevel;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    log.log(this.logLevel, line);
                }
            }
            catch (IOException e) {
                log.error(e);
            }
        }
    }
}

