/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.svc.dba.dao;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Pattern;
import org.bgerp.plugin.svc.dba.model.QueryTable;
import org.bgerp.plugin.svc.dba.model.QueryType;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.util.sql.ConnectionSet;

public class QueryDAO
extends CommonDAO {
    private static final Pattern PATTERN_LIMIT = Pattern.compile("(?i)limit((,)?\\s*\\d+\\s*){1,2}");
    private final ConnectionSet conSet;

    public QueryDAO(ConnectionSet conSet) {
        this.conSet = conSet;
    }

    public void query(QueryTable table, QueryType type, String query) throws SQLException {
        Page page = table.getPage();
        if (type == QueryType.SELECT && !PATTERN_LIMIT.matcher((CharSequence)(query = ((String)query).replaceFirst("(?i)select", "SELECT SQL_CALC_FOUND_ROWS "))).find()) {
            query = (String)query + page.getLimitSql();
        }
        try (Statement st = this.conSet.getConnection().createStatement();){
            st.execute((String)query);
            if (type == QueryType.SELECT || type == QueryType.SHOW || type == QueryType.EXPLAIN) {
                table.set(st.getResultSet());
                if (type == QueryType.SELECT) {
                    page.setRecordCount(st);
                }
            } else {
                table.set("UpdateCount", String.valueOf(st.getUpdateCount()));
            }
        }
    }
}

