/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.msg.email;

import jakarta.mail.MessagingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.l10n.Localization;
import org.bgerp.cache.ParameterCache;
import org.bgerp.dao.expression.Expression;
import org.bgerp.dao.expression.ExpressionContextAccessingObject;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.mail.MailMsg;
import ru.bgcrm.model.param.ParameterEmailValue;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.sql.SingleConnectionSet;

public class ExpressionObject
extends ExpressionContextAccessingObject {
    public ExpressionObject() {
    }

    public ExpressionObject(Process process, DynActionForm form, Connection con) throws Exception {
        this.context = Expression.context(new SingleConnectionSet(con), form, null, process);
    }

    @Override
    public void toContext(Map<String, Object> context) {
        super.toContext(context);
        context.put("email", this);
    }

    public void sendMessageToExecutors(int paramId, String subject, String text) throws BGMessageException, SQLException, MessagingException {
        Process process = (Process)this.context.get("process");
        DynActionForm form = (DynActionForm)((Object)this.context.get("form"));
        Set<Integer> executorIds = process.getExecutorIds().stream().filter(userId -> userId.intValue() != form.getUserId()).collect(Collectors.toSet());
        this.sendMessageToUsers(executorIds, paramId, subject, text);
    }

    public void sendMessageToUsers(Iterable<Integer> userIds, int paramId, String subject, String text) throws BGMessageException, SQLException, MessagingException {
        DynActionForm form = (DynActionForm)((Object)this.context.get("form"));
        Parameter param = null;
        param = paramId == 0 ? (Parameter)ParameterCache.getObjectTypeParameterList("user").stream().filter(p -> "email".equals(p.getType())).findFirst().orElse(null) : ParameterCache.getParameter(paramId);
        if (param == null || !"email".equals(param.getType())) {
            throw new BGMessageException(Localization.getLocalizer("email", form.getHttpRequest()), "Parameter with ID {} not found or has no 'email' type.", paramId);
        }
        try (Connection con = Setup.getSetup().getDBSlaveConnectionFromPool();){
            ParamValueDAO paramDao = new ParamValueDAO(con);
            for (Integer executorId : userIds) {
                for (ParameterEmailValue value : paramDao.getParamEmail(executorId, paramId).values()) {
                    new MailMsg(Setup.getSetup()).send(value.getValue(), subject, text);
                }
            }
        }
    }
}

