/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bil.invoice.action;

import java.sql.Connection;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.util.Date;
import org.apache.struts.action.ActionForward;
import org.bgerp.app.l10n.Localization;
import org.bgerp.plugin.bil.invoice.Config;
import org.bgerp.plugin.report.action.ReportActionBase;
import org.bgerp.plugin.report.model.Column;
import org.bgerp.plugin.report.model.Columns;
import org.bgerp.plugin.report.model.Data;
import org.bgerp.plugin.report.model.Record;
import org.bgerp.util.TimeConvert;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/plugin/report/plugin/invoice/register")
public class ReportRegisterAction
extends ReportActionBase {
    private static final Columns COLUMNS = new Columns(new Column.ColumnInteger("process_id", null, "Process"), new Column.ColumnInteger("invoice_id", null, null), new Column.ColumnString("invoice_type", null, "Type"), new Column.ColumnDecimal("invoice_amount", null, "Amount"), new Column.ColumnDateTime("invoice_created_date", null, "Created", "ymdhm"), new Column.ColumnString("invoice_number", null, "Number"), new Column.ColumnDateTime("invoice_payment_date", null, "Paid", "ymd"), new Column.ColumnInteger("customer_id", null, null), new Column.ColumnString("customer_title", null, "Customer"));

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        return super.unspecified(form, conSet);
    }

    @Override
    public String getTitle() {
        return Localization.getLocalizer(Localization.getLang(), "invoice").l("Invoice Register", new Object[0]);
    }

    @Override
    protected String getHref() {
        return "report/invoice/register";
    }

    @Override
    protected String getJsp() {
        return "/WEB-INF/jspf/user/plugin/invoice/report/register.jsp";
    }

    @Override
    public Columns getColumns() {
        return COLUMNS;
    }

    @Override
    protected ReportActionBase.Selector getSelector() {
        return new ReportActionBase.Selector(){

            @Override
            protected void select(ConnectionSet conSet, Data data) throws Exception {
                Connection con = conSet.getConnection();
                DynActionForm form = data.getForm();
                int userId = form.getUserId();
                Date date = form.getParamDate("dateFrom");
                if (date == null) {
                    form.setParam("dateFrom", TimeUtils.format(TimeConvert.toDate(LocalDate.now().withDayOfMonth(1)), "ymd"));
                    return;
                }
                Config config = ReportRegisterAction.this.setup.getConfig(Config.class);
                try (PreparedQuery pq = new PreparedQuery(con);){
                    pq.addQuery("SELECT SQL_CALC_FOUND_ROWS invoice.id, invoice.type_id, invoice.amount, invoice.create_dt, invoice.number, invoice.payment_date, invoice.process_id, invoice_customer.object_id, invoice_customer.object_title FROM  invoice AS invoice LEFT JOIN  process_link AS invoice_customer ON invoice.process_id=invoice_customer.process_id AND invoice_customer.object_type=?");
                    pq.addString("customer");
                    pq.addQuery(" WHERE ?<=invoice.date_from AND invoice.date_from<=? AND invoice.payment_user_id IN (0,?) ORDER BY invoice.payment_date");
                    pq.addDate(date);
                    pq.addDate(TimeUtils.getEndMonth(date));
                    pq.addInt(userId);
                    ResultSet rs = pq.executeQuery();
                    while (rs.next()) {
                        Record record = data.addRecord();
                        record.add(rs.getInt("invoice.process_id"));
                        record.add(rs.getInt("invoice.id"));
                        record.add(config.getType(rs.getInt("invoice.type_id")).getTitle());
                        record.add(rs.getBigDecimal("invoice.amount"));
                        record.add(rs.getTimestamp("invoice.create_dt"));
                        record.add(rs.getString("invoice.number"));
                        record.add(rs.getDate("invoice.payment_date"));
                        record.add(rs.getInt("invoice_customer.object_id"));
                        record.add(rs.getString("invoice_customer.object_title"));
                    }
                }
            }
        };
    }
}

