/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.process.queue.filter;

import java.math.BigDecimal;
import java.util.Date;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.model.param.Parameter;
import org.bgerp.model.process.queue.filter.Filter;
import org.bgerp.util.sql.LikePattern;
import ru.bgcrm.dao.process.QueueSelectParams;
import ru.bgcrm.model.param.address.AddressHouse;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class FilterParam
extends Filter {
    private Parameter parameter;

    public FilterParam(int id, ConfigMap filter, Parameter parameter) {
        super(id, filter);
        this.parameter = parameter;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public void apply(DynActionForm form, QueueSelectParams params) {
        StringBuilder joinPart = params.joinPart;
        StringBuilder wherePart = params.wherePart;
        int paramId = this.parameter.getId();
        String paramType = this.parameter.getType();
        if ("address".equals(paramType)) {
            String city = form.getParam("param" + this.parameter.getId() + "valueCity");
            String street = form.getParam("param" + this.parameter.getId() + "valueStreet");
            String quarter = form.getParam("param" + this.parameter.getId() + "valueQuarter");
            String houseAndFrac = form.getParam("param" + this.parameter.getId() + "valueHouse");
            int flat = form.getParamInt("param" + this.parameter.getId() + "valueFlat", 0);
            int streetId = form.getParamInt("param" + this.parameter.getId() + "valueStreetId", 0);
            int houseId = form.getParamInt("param" + this.parameter.getId() + "valueHouseId", 0);
            int quarterId = form.getParamInt("param" + this.parameter.getId() + "valueQuarterId", 0);
            int cityId = form.getParamInt("param" + this.parameter.getId() + "valueCityId", 0);
            String paramAlias = " paramAddress" + this.parameter.getId();
            String cityAlias = paramAlias + "city";
            String streetAlias = paramAlias + "street";
            String houseAlias = paramAlias + "house";
            String quarterAlias = paramAlias + "quarter";
            if (cityId > 0 || flat > 0 || houseId > 0 || streetId > 0 || quarterId > 0 || Utils.notEmptyString(city) || Utils.notEmptyString(street) || Utils.notEmptyString(quarter) || Utils.notEmptyString(houseAndFrac)) {
                joinPart.append(" INNER JOIN ");
                joinPart.append(" param_address ");
                joinPart.append(" AS " + paramAlias + " ON process.id=" + paramAlias + ".id AND " + paramAlias + ".param_id=" + this.parameter.getId() + " ");
                if (flat > 0) {
                    joinPart.append(" AND ");
                    joinPart.append(paramAlias + ".flat='" + flat + "' ");
                }
                if (houseId > 0) {
                    joinPart.append(" AND ");
                    joinPart.append(paramAlias + ".house_id=" + houseId + " ");
                } else {
                    joinPart.append(" INNER JOIN ");
                    joinPart.append(" address_house ");
                    joinPart.append(" AS " + houseAlias + " ON " + paramAlias + ".house_id=" + houseAlias + ".id ");
                    if (Utils.notEmptyString(houseAndFrac)) {
                        AddressHouse houseFrac = new AddressHouse().withHouseAndFrac(houseAndFrac);
                        if (houseFrac.getHouse() > 0) {
                            joinPart.append(" AND ");
                            joinPart.append(houseAlias + ".house=" + houseFrac.getHouse() + " ");
                        }
                        if (Utils.notEmptyString(houseFrac.getFrac())) {
                            joinPart.append(" AND ");
                            joinPart.append(houseAlias + ".frac='" + houseFrac.getFrac() + "' ");
                        }
                    }
                    if (quarterId > 0) {
                        joinPart.append(" INNER JOIN ");
                        joinPart.append(" address_quarter ");
                        joinPart.append(" AS " + quarterAlias + " ON " + houseAlias + ".quarter_id=" + quarterAlias + ".id AND" + quarterAlias + ".id=" + quarterId);
                    } else if (Utils.notBlankString(quarter)) {
                        // empty if block
                    }
                    if (streetId > 0) {
                        joinPart.append(" INNER JOIN ");
                        joinPart.append(" address_street ");
                        joinPart.append(" AS " + streetAlias + " ON " + houseAlias + ".street_id=" + streetAlias + ".id AND " + streetAlias + ".id=" + streetId);
                    } else if (Utils.notEmptyString(street)) {
                        joinPart.append(" INNER JOIN ");
                        joinPart.append(" address_street ");
                        joinPart.append(" AS " + streetAlias + " ON " + houseAlias + ".street_id=" + streetAlias + ".id AND " + streetAlias + ".title LIKE '%" + street + "%' ");
                    }
                    Runnable addStreetJoin = () -> {
                        if (!joinPart.toString().contains(streetAlias)) {
                            joinPart.append(" INNER JOIN ");
                            joinPart.append(" address_street ");
                            joinPart.append(" AS " + streetAlias + " ON " + houseAlias + ".street_id=" + streetAlias + ".id ");
                        }
                    };
                    if (streetId <= 0 && quarterId <= 0) {
                        if (cityId > 0) {
                            addStreetJoin.run();
                            joinPart.append(" AND " + streetAlias + ".city_id=" + cityId);
                        } else if (Utils.notBlankString(city)) {
                            addStreetJoin.run();
                            joinPart.append(" INNER JOIN ");
                            joinPart.append(" address_city ");
                            joinPart.append(" AS " + cityAlias + " ON " + cityAlias + ".id=" + streetAlias + ".city_id AND " + cityAlias + ".title LIKE '%" + city + "%' ");
                        }
                    }
                }
            }
        } else if ("date".equals(paramType) || "datetime".equals(paramType)) {
            String paramPrefix = "dateTimeParam" + this.parameter.getId();
            boolean orEmpty = this.configMap.getBoolean("orEmpty", false);
            Date dateFrom = form.getParamDate(paramPrefix + "From");
            Date dateTo = form.getParamDate(paramPrefix + "To");
            if (this.configMap.get("valueFrom", "").equals("curdate")) {
                dateFrom = new Date();
            }
            if (this.configMap.get("valueTo", "").equals("curdate")) {
                dateTo = new Date();
            }
            String tableAlias = "param_dx_" + this.parameter.getId();
            if (dateFrom != null || dateTo != null || orEmpty) {
                joinPart.append(" INNER JOIN param_" + this.parameter.getType() + " AS " + tableAlias + " ON process.id=" + tableAlias + ".id AND " + tableAlias + ".param_id=" + this.parameter.getId());
                if (orEmpty) {
                    joinPart.append(" AND (" + tableAlias + ".param_id IS NULL OR (1>0 ");
                }
                if (dateFrom != null) {
                    joinPart.append(" AND " + tableAlias + ".value>=" + TimeUtils.formatSqlDate(dateFrom));
                }
                if (dateTo != null) {
                    joinPart.append(" AND " + tableAlias + ".value<" + TimeUtils.formatSqlDate(TimeUtils.getNextDay(dateTo)));
                }
                if (orEmpty) {
                    joinPart.append("))");
                }
            }
        } else if ("list".equals(paramType) || "listcount".equals(paramType)) {
            String values = this.getValues(form, "param" + paramId + "value");
            if (Utils.isBlankString(values)) {
                return;
            }
            String tableAlias = "param_lx_" + paramId;
            joinPart.append(" INNER JOIN ");
            if ("list".equals(paramType)) {
                joinPart.append(" param_list ");
            } else {
                joinPart.append(" param_listcount ");
            }
            joinPart.append("AS " + tableAlias + " ON process.id=" + tableAlias + ".id AND " + tableAlias + ".param_id=" + paramId + " AND " + tableAlias + ".value IN(" + values + ")");
        } else if ("money".equals(paramType)) {
            String tableAlias = "param_money_" + paramId;
            if (joinPart.toString().contains(tableAlias) || wherePart.toString().contains(tableAlias)) {
                this.log.error("Duplicated filter on param type 'money' with ID: ", this.getId());
            } else {
                boolean empty = form.getParamBoolean("param" + paramId + "empty");
                BigDecimal from = Utils.parseBigDecimal(form.getParam("param" + paramId + "From"), null);
                BigDecimal to = Utils.parseBigDecimal(form.getParam("param" + paramId + "To"), null);
                if (empty || from != null || to != null) {
                    if (empty) {
                        joinPart.append(" LEFT JOIN ");
                    } else {
                        joinPart.append(" INNER JOIN ");
                    }
                    joinPart.append(" param_money ");
                    joinPart.append("AS " + tableAlias + " ON process.id=" + tableAlias + ".id AND " + tableAlias + ".param_id=" + paramId);
                    if (empty) {
                        wherePart.append(" AND " + tableAlias + ".value IS NULL ");
                    } else {
                        if (from != null) {
                            joinPart.append(" AND " + Utils.format(from) + "<=" + tableAlias + ".value ");
                        }
                        if (to != null) {
                            joinPart.append(" AND " + tableAlias + ".value<=" + Utils.format(to));
                        }
                    }
                }
            }
        } else if ("text".equals(paramType) || "blob".equals(paramType)) {
            String mode = this.configMap.get("mode");
            String value = form.getParam("param" + paramId + "value");
            if (Utils.notBlankString(value)) {
                joinPart.append(" INNER JOIN ");
                if ("blob".equals(paramType)) {
                    joinPart.append(" param_blob ");
                } else if ("text".equals(paramType)) {
                    joinPart.append(" param_text ");
                }
                if ("regexp".equals(mode)) {
                    joinPart.append("AS param_text ON process.id=param_text.id AND param_text.param_id=" + paramId + " AND param_text.value RLIKE '" + value + "'");
                }
                if ("numeric".equals(mode)) {
                    joinPart.append("AS param_text ON process.id=param_text.id AND param_text.param_id=" + paramId + " AND ( 1>1 ");
                    for (String val : value.split(",")) {
                        if (val.contains("-")) {
                            String[] bVal = val.split("-");
                            joinPart.append(" OR param_text.value between '" + bVal[0] + "' AND '" + bVal[1] + "'");
                            continue;
                        }
                        joinPart.append(" OR param_text.value = '" + val + "'");
                    }
                    joinPart.append(" )");
                } else {
                    joinPart.append(" AS param_text ON process.id=param_text.id AND param_text.param_id=" + paramId + " AND param_text.value LIKE '" + LikePattern.SUB.get(value) + "'");
                }
            }
        }
    }
}

