/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.process.link.config;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import ru.bgcrm.util.Utils;

public class ProcessLinkCategory
extends Config {
    private final int id;
    private final String title;
    private final boolean link;
    private final String linkType;
    private final Set<Integer> processTypeIds;
    private final boolean add;
    private final List<Integer> addProcessStatusIds;

    ProcessLinkCategory(int id, ConfigMap config) throws Config.InitStopException {
        super(null);
        this.id = id;
        this.title = config.get("title", "??? " + id);
        this.link = config.getBoolean("link", true);
        this.linkType = config.get("link.type", "processLink");
        this.initWhen(this.linkType.equals("processDepend") || this.linkType.equals("processLink") || this.linkType.equals("processMade"));
        this.processTypeIds = Collections.unmodifiableSet(Utils.toIntegerSet(config.get("process.types")));
        this.add = config.getBoolean("add", true);
        this.addProcessStatusIds = !this.add ? null : Collections.unmodifiableList(Utils.toIntegerList(config.get("add.process.statuses")));
    }

    public int getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isLink() {
        return this.link;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public Set<Integer> getProcessTypeIds() {
        return this.processTypeIds;
    }

    public boolean isAdd() {
        return this.add;
    }

    public List<Integer> getAddProcessStatusIds() {
        return this.addProcessStatusIds;
    }
}

