/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.process.config;

import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.util.Dynamic;
import ru.bgcrm.util.Utils;

@Bean
public class ProcessPriorityConfig
extends Config {
    private static final String PREFIX = "process.priority.";
    private static final SortedMap<Integer, String> DEFAULT_COLORS = Collections.unmodifiableSortedMap(new TreeMap<Integer, String>(Map.of(0, "#ffffff", 1, "#ffffff", 2, "#9ad78a", 3, "#9ad78a", 4, "#fff1a4", 5, "#fff1a4", 6, "#ffbe7e", 7, "#ffbe7e", 8, "#ffbe7e", 9, "#fd7d89")));
    private final SortedMap<Integer, String> priorityColors;
    private final Map<Integer, String> priorityDescriptions;

    protected ProcessPriorityConfig(ConfigMap config) {
        super(null);
        this.priorityColors = this.loadPriorityColors(config);
        this.priorityDescriptions = this.loadPriorityDescriptions(config);
    }

    private SortedMap<Integer, String> loadPriorityColors(ConfigMap config) {
        SortedMap<Integer, ConfigMap> map = config.subIndexed(PREFIX);
        TreeMap<Integer, String> result = new TreeMap<Integer, String>();
        for (Map.Entry<Integer, ConfigMap> me : map.entrySet()) {
            String color = me.getValue().get("color");
            if (!Utils.notBlankString(color)) continue;
            result.put(me.getKey(), color);
        }
        if (result.isEmpty()) {
            return DEFAULT_COLORS;
        }
        return Collections.unmodifiableSortedMap(result);
    }

    private Map<Integer, String> loadPriorityDescriptions(ConfigMap config) {
        SortedMap<Integer, ConfigMap> map = config.subIndexed(PREFIX);
        TreeMap<Integer, String> result = new TreeMap<Integer, String>();
        for (Map.Entry<Integer, ConfigMap> me : map.entrySet()) {
            result.put(me.getKey(), me.getValue().get("description", ""));
        }
        return Collections.unmodifiableMap(result);
    }

    @Dynamic
    public SortedMap<Integer, String> getPriorityColors() {
        return this.priorityColors;
    }

    public String getPriorityDescription(int value) {
        return this.priorityDescriptions.get(value);
    }
}

