/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.process.config;

import java.util.Set;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.util.Log;
import ru.bgcrm.util.Utils;

public class ProcessCreateInConfig
extends Config {
    private static final Log log = Log.getLog();
    private final Set<String> areas;
    private final String copyParams;
    private final ConfigMap config;

    protected ProcessCreateInConfig(ConfigMap config) {
        super(null);
        Set<String> objectTypes;
        config = config.sub("create.in.");
        this.areas = Utils.toSet(config.get("areas", "*"));
        if (this.areas.contains("linked")) {
            log.warnd("Used deprecated 'linked' value in 'create.in.areas'", new Object[0]);
        }
        if (!(objectTypes = Utils.toSet(config.get("objectTypes"))).isEmpty()) {
            log.warnd("Used deprecated key 'create.in.objectTypes', place the values to 'create.in.areas' instead", new Object[0]);
            this.areas.addAll(objectTypes);
        }
        this.copyParams = config.get("copyParams", "");
        this.config = config;
    }

    public boolean check(String area) {
        return this.areas.contains(area) || this.areas.contains("*");
    }

    public String getCopyParams() {
        return this.copyParams;
    }

    public boolean openCreated(String area) {
        return this.config.getBoolean(area + ".openCreated", this.config.getBoolean("*.openCreated"));
    }

    public boolean selected(String area) {
        return this.config.getBoolean(area + ".selected", this.config.getBoolean("*.selected"));
    }
}

