/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.file;

import java.io.File;

public class FileStat {
    private int files;
    private int dirs;
    private long size;

    public FileStat(File dir) {
        this.stat(dir);
    }

    private void stat(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                ++this.dirs;
                this.stat(f);
                continue;
            }
            ++this.files;
            this.size += f.length();
        }
    }

    public int files() {
        return this.files;
    }

    public int dirs() {
        return this.dirs;
    }

    public long size() {
        return this.size;
    }

    public String toString() {
        return "FileStat [files=" + this.files + ", dirs=" + this.dirs + ", size=" + this.size + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.files;
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileStat other = (FileStat)obj;
        if (this.files != other.files) {
            return false;
        }
        return this.size == other.size;
    }
}

