/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.param;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.exception.BGException;
import org.bgerp.cache.ParameterCache;
import org.bgerp.model.Pageable;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.Log;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.param.ParameterPhoneValue;
import ru.bgcrm.model.param.ParameterPhoneValueItem;
import ru.bgcrm.model.param.ParameterSearchedObject;
import ru.bgcrm.util.Utils;

@Deprecated
public class OldParamSearchDAO
extends CommonDAO {
    private static Log log = Log.getLog();

    public OldParamSearchDAO(Connection con) {
        super(con);
    }

    public static String getParamJoinFilters(String expression, String objectId) throws SQLException {
        StringBuilder result = new StringBuilder();
        String[] tokens = expression.split("\\s+");
        if (tokens.length != 3) {
            log.error("Incorrect filter expression: " + expression, new Object[0]);
            return "";
        }
        String paramMacro = tokens[0];
        String function = tokens[1];
        Set<Integer> values = Utils.toIntegerSet(tokens[2]);
        if (!function.equals("in")) {
            log.error("Incorrect function: " + function + " in expression: " + expression, new Object[0]);
            return "";
        }
        tokens = paramMacro.split(":");
        if (!paramMacro.startsWith("param:") || tokens.length != 3) {
            log.error("Incorrect param macro: " + paramMacro + " in expression: " + expression, new Object[0]);
            return "";
        }
        String paramId = tokens[1];
        Parameter param = ParameterCache.getParameter(Utils.parseInt(paramId));
        if (param == null) {
            log.error("Param not found: " + paramId + " or not address in expression: " + expression, new Object[0]);
            return "";
        }
        if ("in".equals(function) && "list".equals(param.getType())) {
            String tableName = "param_" + param.getId() + "_val";
            result.append(" INNER JOIN ");
            result.append(" param_list ");
            result.append("AS " + tableName);
            result.append(" ON " + tableName + ".id=" + objectId + " AND " + tableName + ".param_id=" + param.getId() + " AND " + tableName + ".value IN (" + Utils.toString(values) + ") ");
        }
        return result.toString();
    }

    public Set<Integer> searchObjectByParameterPhone(int parameterId, ParameterPhoneValue parameterPhoneValue) throws SQLException {
        HashSet<Integer> result = new HashSet<Integer>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append("item.id AS object_id");
        query.append(" FROM ");
        query.append(" param_phone_item ");
        query.append(" AS item ");
        query.append(" WHERE ");
        query.append("item.param_id = ? ");
        query.append("AND (");
        List<ParameterPhoneValueItem> phoneItems = parameterPhoneValue.getItemList();
        for (int index = 0; index < phoneItems.size(); ++index) {
            if (index > 0) {
                query.append(" OR");
            }
            query.append(" item.phone LIKE '%" + phoneItems.get(index).getPhone() + "'");
        }
        query.append(" )");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, parameterId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(rs.getInt("object_id"));
        }
        ps.close();
        return result;
    }

    public Set<Integer> searchObjectByParameterText(int parameterId, String parameterTextValue) throws SQLException {
        HashSet<Integer> result = new HashSet<Integer>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append("text.id AS object_id ");
        query.append(" FROM ");
        query.append(" param_text ");
        query.append(" AS text ");
        query.append(" WHERE ");
        query.append("text.param_id = ? ");
        query.append("AND text.value = ? ");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, parameterId);
        ps.setString(2, parameterTextValue);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(rs.getInt("object_id"));
        }
        ps.close();
        return result;
    }

    public Set<Integer> searchObjectByParameterList(int parameterId, int value) throws Exception {
        HashSet<Integer> result = new HashSet<Integer>();
        try (PreparedQuery pq = new PreparedQuery(this.con);){
            pq.addQuery("SELECT ");
            pq.addQuery("list.id AS object_id");
            pq.addQuery(" FROM ");
            pq.addQuery(" param_list ");
            pq.addQuery(" AS list ");
            pq.addQuery(" WHERE ");
            pq.addQuery("list.param_id=? AND list.value=?");
            pq.addInt(parameterId);
            pq.addInt(value);
            try (ResultSet rs = pq.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getInt(1));
                }
            }
        }
        return result;
    }

    public <T> void searchObjectListByEmail(String tableName, Extractor<T> extractor, Pageable<ParameterSearchedObject<T>> searchResult, List<Integer> emailParamIdList, String email) {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List<ParameterSearchedObject<T>> list = searchResult.getList();
            StringBuilder query = new StringBuilder();
            String ids = Utils.toString(emailParamIdList);
            query.append("SELECT ");
            query.append("DISTINCT param.param_id, param.value, c.*");
            query.append(" FROM ");
            query.append(tableName);
            query.append("AS c ");
            query.append(" INNER JOIN ");
            query.append(" param_email ");
            query.append("AS param ON c.id=param.id AND param.value IN (?,?)");
            if (Utils.notBlankString(ids)) {
                query.append(" AND param.param_id IN (");
                query.append(ids);
                query.append(")");
            }
            query.append(" GROUP BY c.id ");
            query.append(" ORDER BY ");
            query.append("c.title");
            query.append(page.getLimitSql());
            try {
                String domainName = StringUtils.substringAfter((String)email, (String)"@");
                PreparedStatement ps = this.con.prepareStatement(query.toString());
                ps.setString(1, email);
                ps.setString(2, domainName);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(new ParameterSearchedObject<T>(extractor.extract(rs), rs.getInt(1), rs.getString(2)));
                }
                page.setRecordCount(ps);
                ps.close();
            }
            catch (SQLException ex) {
                throw new BGException(ex);
            }
        }
    }

    public static interface Extractor<T> {
        public T extract(ResultSet var1) throws SQLException;
    }
}

