/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bgerp.app.event.PrioritizedListener;
import org.bgerp.app.event.iface.Event;
import org.bgerp.app.event.iface.EventListener;
import org.bgerp.util.Log;
import ru.bgcrm.util.sql.ConnectionSet;

public class EventProcessor {
    private static final Log log = Log.getLog();
    private static final Map<Class<?>, List<PrioritizedListener>> SUBSCRIBERS = new ConcurrentHashMap();

    public static <E extends Event> void subscribe(EventListener<? super E> l, Class<E> clazz) {
        EventProcessor.subscribe(l, clazz, 0);
    }

    public static <E extends Event> void subscribe(EventListener<? super E> l, Class<E> clazz, int priority) {
        List list = SUBSCRIBERS.computeIfAbsent(clazz, c -> new ArrayList());
        PrioritizedListener item = new PrioritizedListener(l, priority);
        for (int i = 0; i < list.size(); ++i) {
            if (((PrioritizedListener)list.get(i)).priority() >= priority) continue;
            list.add(i, item);
            return;
        }
        list.add(item);
    }

    public static void unsubscribe(EventListener<?> l) {
        SUBSCRIBERS.values().remove(l);
    }

    public static void processEvent(Event event, ConnectionSet conSet) throws Exception {
        log.trace("Processing event: {}", event);
        List<PrioritizedListener> listeners = SUBSCRIBERS.get(event.getClass());
        if (listeners != null) {
            for (PrioritizedListener item : listeners) {
                if (!event.processing()) break;
                item.listener().notify(event, conSet);
            }
        }
    }
}

