/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.struts.action;

import java.sql.Connection;
import java.util.List;
import java.util.SortedMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGIllegalArgumentException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.dao.param.ParamDAO;
import org.bgerp.dao.param.ParamGroupDAO;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.param.Parameter;
import org.bgerp.model.param.ParameterValue;
import org.bgerp.util.sql.LikePattern;
import ru.bgcrm.dao.CustomerDAO;
import ru.bgcrm.dao.CustomerLinkDAO;
import ru.bgcrm.dao.PatternDAO;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.event.customer.CustomerChangedEvent;
import ru.bgcrm.event.customer.CustomerRemovedEvent;
import ru.bgcrm.event.link.LinkAddingEvent;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.customer.Customer;
import ru.bgcrm.model.param.ParameterAddressValue;
import ru.bgcrm.model.param.ParameterEmailValue;
import ru.bgcrm.model.param.ParameterPhoneValue;
import ru.bgcrm.model.param.ParameterPhoneValueItem;
import ru.bgcrm.model.param.Pattern;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;
import ru.bgcrm.util.sql.SingleConnectionSet;

@ActionServlet.Action(path="/user/customer")
public class CustomerAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/user/customer";

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        return this.customer(form, conSet);
    }

    public ActionForward customerCreate(DynActionForm form, ConnectionSet conSet) throws Exception {
        String title = form.getParam("title", this.l.l("\u041d\u043e\u0432\u044b\u0439 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442", new Object[0]));
        Customer customer = new Customer();
        customer.setTitle(title);
        new CustomerDAO(conSet.getConnection()).updateCustomer(customer);
        form.setResponseData("customer", customer);
        return this.json(conSet, form);
    }

    public ActionForward customerGet(DynActionForm form, ConnectionSet conSet) throws Exception {
        Connection con = conSet.getConnection();
        CustomerDAO customerDAO = new CustomerDAO(con);
        PatternDAO patternDAO = new PatternDAO(con);
        ParamGroupDAO groupDAO = new ParamGroupDAO(con);
        Customer customer = customerDAO.getCustomerById(form.getId());
        if (customer != null) {
            customer.setGroupIds(customerDAO.getGroupIds(form.getId()));
            form.setResponseData("customer", customer);
            HttpServletRequest request = form.getHttpRequest();
            request.setAttribute("patternList", patternDAO.getPatternList("customer"));
            request.setAttribute("parameterGroupList", groupDAO.getParameterGroupList("customer"));
        }
        return this.html(conSet, form, "/WEB-INF/jspf/user/customer/edit.jsp");
    }

    public ActionForward customerUpdate(DynActionForm form, ConnectionSet conSet) throws Exception {
        CustomerDAO customerDAO = new CustomerDAO(conSet.getConnection(), true, form.getUserId());
        Customer customer = customerDAO.getCustomerById(form.getId());
        if (customer == null) {
            throw new BGMessageException("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.", new Object[0]);
        }
        String titleBefore = Utils.maskNull(customer.getTitle());
        customer.setTitle(form.getParam("title"));
        customer.setTitlePattern(form.getParam("titlePattern", ""));
        customer.setTitlePatternId(form.getParamInt("titlePatternId", -1));
        customer.setParamGroupId(Utils.parseInt(form.getParam("parameterGroupId")));
        customer.setGroupIds(form.getParamValues("customerGroupId"));
        if (Utils.isBlankString(customer.getTitle()) && customer.getTitlePatternId() <= 0 && Utils.isBlankString(customer.getTitlePattern())) {
            throw new BGIllegalArgumentException();
        }
        customerDAO.updateCustomerTitle(titleBefore, customer, -1, form.getResponse());
        customerDAO.updateGroupIds(customer.getId(), form.getParamValues("customerGroupId"));
        CustomerChangedEvent updateEvent = new CustomerChangedEvent(form, form.getId());
        EventProcessor.processEvent(updateEvent, conSet);
        return this.json(conSet, form);
    }

    public ActionForward customerDelete(DynActionForm form, ConnectionSet conSet) throws Exception {
        Connection con = conSet.getConnection();
        new CustomerDAO(con).deleteCustomer(form.getId());
        new ParamValueDAO(con).deleteParams("customer", form.getId());
        new CustomerLinkDAO(con).deleteObjectLinks(form.getId());
        CustomerRemovedEvent deleteEvent = new CustomerRemovedEvent(form, form.getId());
        EventProcessor.processEvent(deleteEvent, new SingleConnectionSet(con));
        return this.json(conSet, form);
    }

    public ActionForward customer(DynActionForm form, ConnectionSet conSet) throws Exception {
        CustomerDAO customerDAO = new CustomerDAO(conSet.getConnection());
        Customer customer = customerDAO.getCustomerById(form.getId());
        if (customer != null) {
            customer.setGroupIds(customerDAO.getGroupIds(form.getId()));
            form.setResponseData("customer", customer);
        }
        return this.html(conSet, form, "/WEB-INF/jspf/user/customer/customer.jsp");
    }

    public ActionForward customerTitleList(DynActionForm form, ConnectionSet conSet) throws Exception {
        List<String> titles = new CustomerDAO(conSet.getConnection()).getCustomerTitles(LikePattern.SUB.get(form.getParam("title")), this.setup.getInt("customer.search.by.title.count", 10));
        form.setResponseData("list", titles);
        return this.html(conSet, form, "/WEB-INF/jspf/user/customer/customer.jsp");
    }

    public ActionForward customerMerge(DynActionForm form, ConnectionSet conSet) throws Exception {
        Integer customerId = form.getParamInt("customerId");
        Integer mergingCustomerId = form.getParamInt("mergingCustomerId");
        Connection con = conSet.getConnection();
        ParamValueDAO paramValueDAO = new ParamValueDAO(con);
        CustomerLinkDAO customerLinkDAO = new CustomerLinkDAO(con);
        List<Parameter> customerParameterList = new ParamDAO(con).getParameterList("customer", 0);
        List<ParameterValue> customerParamValues = paramValueDAO.loadParameters(customerParameterList, customerId, true);
        List<ParameterValue> mergingCustomerParamValues = paramValueDAO.loadParameters(customerParameterList, mergingCustomerId, true);
        for (Parameter param : customerParameterList) {
            String type = param.getType();
            Object paramCustomerValue = "";
            Object paramMergingCustomerValue = "";
            int paramId = param.getId();
            for (ParameterValue customerPVP : customerParamValues) {
                if (customerPVP.getParameter().getId() != paramId) continue;
                paramCustomerValue = customerPVP.getValue();
                break;
            }
            for (ParameterValue mergingCustomerPVP : mergingCustomerParamValues) {
                if (mergingCustomerPVP.getParameter().getId() != paramId) continue;
                paramMergingCustomerValue = mergingCustomerPVP.getValue();
                break;
            }
            if (paramCustomerValue != null && paramMergingCustomerValue != null) {
                boolean exist;
                boolean isMultiple = param.getConfigMap().getBoolean("multiple", false);
                if ("address".equals(type) && isMultiple) {
                    SortedMap<Integer, ParameterAddressValue> customerAddressMap = paramValueDAO.getParamAddress(customerId, paramId);
                    SortedMap<Integer, ParameterAddressValue> mergingCustomerAddressMap = paramValueDAO.getParamAddress(mergingCustomerId, paramId);
                    for (ParameterAddressValue addressValue : mergingCustomerAddressMap.values()) {
                        exist = false;
                        for (ParameterAddressValue existAddressValue : customerAddressMap.values()) {
                            if (!existAddressValue.equals(addressValue)) continue;
                            exist = true;
                        }
                        if (exist) continue;
                        paramValueDAO.updateParamAddress(customerId, paramId, 0, addressValue);
                    }
                    continue;
                }
                if ("phone".equals(type)) {
                    ParameterPhoneValue customerPhoneValue = paramValueDAO.getParamPhone(customerId, paramId);
                    ParameterPhoneValue mergingCustomerPhoneValue = paramValueDAO.getParamPhone(mergingCustomerId, paramId);
                    for (ParameterPhoneValueItem phoneItem : mergingCustomerPhoneValue.getItemList()) {
                        exist = false;
                        for (ParameterPhoneValueItem existPhoneValue : customerPhoneValue.getItemList()) {
                            if (!existPhoneValue.equals(phoneItem)) continue;
                            exist = true;
                        }
                        if (exist) continue;
                        customerPhoneValue.addItem(phoneItem);
                    }
                    paramValueDAO.updateParamPhone(customerId, paramId, customerPhoneValue);
                    continue;
                }
                if ("email".equals(type) && isMultiple) {
                    SortedMap<Integer, ParameterEmailValue> mergingCustomerEmailMap = paramValueDAO.getParamEmail(mergingCustomerId, paramId);
                    SortedMap<Integer, ParameterEmailValue> customerEmailMap = paramValueDAO.getParamEmail(customerId, paramId);
                    for (ParameterEmailValue emailValue : mergingCustomerEmailMap.values()) {
                        exist = false;
                        for (ParameterEmailValue existEmailValue : customerEmailMap.values()) {
                            if (!existEmailValue.equals(emailValue)) continue;
                            exist = true;
                        }
                        if (exist) continue;
                        paramValueDAO.updateParamEmail(customerId, paramId, 0, emailValue);
                    }
                    continue;
                }
                if (paramCustomerValue.equals(paramMergingCustomerValue)) continue;
                throw new BGMessageException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 '" + param.getTitle() + "' \u0434\u043e\u043b\u0436\u043d\u044b \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0442\u044c", new Object[0]);
            }
            if (paramMergingCustomerValue == null) continue;
            paramValueDAO.copyParam(mergingCustomerId, customerId, paramId);
        }
        for (CommonObjectLink link : customerLinkDAO.getObjectLinksWithType(mergingCustomerId, "")) {
            customerLinkDAO.deleteLink(link);
            link.setObjectId(customerId);
            link.setObjectType("customer");
            LinkAddingEvent event = new LinkAddingEvent(form, link);
            EventProcessor.processEvent(event, new SingleConnectionSet(con));
            customerLinkDAO.addLink(link);
        }
        new ProcessLinkDAO(con).linkToAnotherObject(mergingCustomerId, "customer", customerId, "customer", "", "");
        EventProcessor.processEvent(new CustomerChangedEvent(form, customerId), conSet);
        EventProcessor.processEvent(new CustomerRemovedEvent(form, mergingCustomerId), conSet);
        new CustomerDAO(con).deleteCustomer(mergingCustomerId);
        new CustomerLinkDAO(con).deleteObjectLinks(mergingCustomerId);
        return this.json(con, form);
    }

    protected void formatCustomerTitle(Customer customer, CustomerDAO customerDAO, ParamValueDAO paramDAO, Connection con) throws Exception {
        Pattern pattern;
        PatternDAO patternDAO = new PatternDAO(con);
        String titlePattern = customer.getTitlePattern();
        if (customer.getTitlePatternId() > 0 && (pattern = patternDAO.getPattern(customer.getTitlePatternId())) != null) {
            titlePattern = pattern.getPattern();
        }
        customer.setTitle(Utils.formatPatternString("customer", customer.getId(), paramDAO, titlePattern));
        customerDAO.updateCustomer(customer);
    }

    protected void setCustomerTitle(String title, Customer customer, PatternDAO patternDAO, ParamValueDAO paramDAO) throws Exception {
        if (customer.getTitlePatternId() == 0) {
            customer.setTitle(Utils.formatPatternString("customer", customer.getId(), paramDAO, customer.getTitlePattern()));
        } else if (customer.getTitlePatternId() > 0) {
            Pattern pattern = patternDAO.getPattern(customer.getTitlePatternId());
            customer.setTitle(Utils.formatPatternString("customer", customer.getId(), paramDAO, pattern.getPattern()));
        } else {
            customer.setTitle(title);
        }
    }
}

