/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process.config;

import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;

public class ProcessPriorityConfig
extends Config {
    private static final String PREFIX = "process.priority.";
    private static final SortedMap<Integer, String> DEFAULT_COLORS = Collections.unmodifiableSortedMap(new TreeMap<Integer, String>(Map.of(0, "#FFFFFF", 1, "#FFFFFF", 2, "#9AD78A", 3, "#9AD78A", 4, "#FFF1A4", 5, "#FFF1A4", 6, "#FFBE7E", 7, "#FFBE7E", 8, "#FFBE7E", 9, "#FD7D89")));
    private final SortedMap<Integer, String> priorityColors;

    protected ProcessPriorityConfig(ConfigMap config) {
        super(null);
        this.priorityColors = this.loadPriorityColors(config);
    }

    private SortedMap<Integer, String> loadPriorityColors(ConfigMap config) {
        SortedMap<Integer, ConfigMap> map = config.subIndexed(PREFIX);
        if (map.isEmpty()) {
            return DEFAULT_COLORS;
        }
        TreeMap<Integer, String> result = new TreeMap<Integer, String>();
        for (Map.Entry<Integer, ConfigMap> me : map.entrySet()) {
            result.put(me.getKey(), me.getValue().get("color", "red"));
        }
        return Collections.unmodifiableSortedMap(result);
    }

    public SortedMap<Integer, String> getPriorityColors() {
        return this.priorityColors;
    }
}

