/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bgerp.app.cfg.ConfigMap;
import ru.bgcrm.model.process.TypeProperties;
import ru.bgcrm.model.process.wizard.base.Step;

public class Wizard {
    private final List<Step> createStepList = new ArrayList<Step>();
    private final List<Step> stepList = new ArrayList<Step>();

    public Wizard(TypeProperties props) {
        ConfigMap configMap = props.getConfigMap();
        ConfigMap wizardConf = configMap.subSok("wizard.", "createWizard.");
        this.loadSteps(wizardConf, "createStep.", this.createStepList);
        this.loadSteps(wizardConf, "step.", this.stepList);
    }

    protected void loadSteps(ConfigMap wizardConf, String prefix, List<Step> stepList) {
        for (Map.Entry<Integer, ConfigMap> me : wizardConf.subIndexed(prefix).entrySet()) {
            ConfigMap config = me.getValue();
            String className = config.get("class");
            Step step = Step.newInstance(className, config);
            if (step == null) continue;
            stepList.add(step);
        }
    }

    public List<Step> getCreateStepList() {
        return this.createStepList;
    }

    public List<Step> getStepList() {
        return this.stepList;
    }
}

