/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao.message;

import java.sql.Connection;
import java.util.Date;
import java.util.Map;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.l10n.Localization;
import org.bgerp.app.l10n.Localizer;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.model.file.tmp.FileInfo;
import org.bgerp.model.file.tmp.SessionTemporaryFiles;
import org.bgerp.model.msg.Message;
import org.bgerp.util.Log;
import ru.bgcrm.dao.message.MessageDAO;
import ru.bgcrm.dao.message.MessageType;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.event.process.ProcessMessageAddedEvent;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;
import ru.bgcrm.util.sql.SingleConnectionSet;

@Bean
public class MessageTypeNote
extends MessageType {
    private static final Log log = Log.getLog();
    private final boolean createUnread;

    public MessageTypeNote(Setup setup, int id, ConfigMap config) {
        super(setup, id, config.get("title"), config);
        this.createUnread = config.getBoolean("create.unread");
    }

    @Override
    public boolean isAnswerSupport() {
        return true;
    }

    @Override
    public Message getAnswerMessage(Message original) {
        Message result = new Message();
        result.setTypeId(original.getTypeId());
        result.setProcessId(original.getProcessId());
        Object subject = Utils.maskNull(original.getSubject());
        subject = ((String)subject).startsWith("Re:") ? subject : "Re: " + (String)subject;
        result.setSubject((String)subject);
        result.setText(this.answerText(original.getText()));
        result.setTo(original.getFrom());
        return result;
    }

    @Override
    public boolean isAttachmentSupport() {
        return true;
    }

    @Override
    public boolean isEditable(Message message) {
        return true;
    }

    @Override
    public boolean isRemovable(Message message) {
        return true;
    }

    @Override
    public boolean isProcessChangeSupport() {
        return true;
    }

    @Override
    public String getProcessMessageHeaderColor(Message message) {
        return "#e6fb9d";
    }

    @Override
    public String getEditorJsp() {
        return "/WEB-INF/jspf/user/message/process/edit/note/editor.jsp";
    }

    @Override
    public String getMessageDescription(String lang, Message message) {
        Localizer l = Localization.getLocalizer(lang, "kernel");
        StringBuilder result = new StringBuilder(200);
        result.append(this.getTitle()).append(": \"").append(message.getSubject()).append("\"; ").append(l.l("\u0441\u043e\u0437\u0434\u0430\u043d\u043e: ", new Object[0])).append(TimeUtils.format(message.getFromTime(), "ymdhm"));
        return result.toString();
    }

    @Override
    public void messageDelete(ConnectionSet conSet, String ... messageIds) throws Exception {
        for (String messageId : messageIds) {
            new MessageDAO(conSet.getConnection()).deleteMessage(Utils.parseInt(messageId));
        }
    }

    @Override
    public void updateMessage(Connection con, DynActionForm form, Message message) throws Exception {
        message.setSystemId("");
        message.setFrom("");
        if (!this.createUnread) {
            message.setToTime(new Date());
        }
        message.setDirection(1);
        Map<Integer, FileInfo> tmpFiles = this.processMessageAttaches(con, form, message);
        new MessageDAO(con).updateMessage(message);
        SessionTemporaryFiles.deleteFiles(form, tmpFiles.keySet());
        int processId = message.getProcessId();
        if (processId > 0) {
            Process process = new ProcessDAO(con).getProcess(processId);
            ProcessType type = ProcessTypeCache.getProcessType(process.getTypeId());
            if (type == null) {
                log.error("Not found process type with id:" + process.getTypeId(), new Object[0]);
            } else {
                EventProcessor.processEvent(new ProcessMessageAddedEvent(form, message, process), new SingleConnectionSet(con));
            }
        }
    }
}

