/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bgerp.model.base.Id;
import org.bgerp.util.Log;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.Period;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.sql.SQLUtils;

public class CommonDAO {
    protected final Log log = Log.getLog(this.getClass());
    protected static final String SQL_SELECT = "SELECT ";
    protected static final String SQL_SELECT_ALL_FROM = "SELECT * FROM ";
    protected static final String SQL_SELECT_COUNT_ROWS = "SELECT SQL_CALC_FOUND_ROWS ";
    protected static final String SQL_DISTINCT = "DISTINCT ";
    protected static final String SQL_INSERT_IGNORE = "INSERT IGNORE INTO ";
    protected static final String SQL_INSERT_INTO = "INSERT INTO ";
    protected static final String SQL_VALUES = " VALUES ";
    protected static final String SQL_VALUES_1 = " VALUES (?)";
    protected static final String SQL_VALUES_2 = " VALUES (?, ?)";
    protected static final String SQL_VALUES_3 = " VALUES (?, ?, ?)";
    protected static final String SQL_VALUES_4 = " VALUES (?, ?, ?, ?)";
    protected static final String SQL_VALUES_5 = " VALUES (?, ?, ?, ?, ?)";
    protected static final String SQL_SET = " SET ";
    protected static final String SQL_UPDATE = "UPDATE ";
    protected static final String SQL_DELETE = "DELETE ";
    protected static final String SQL_DELETE_FROM = "DELETE FROM ";
    protected static final String SQL_FROM = " FROM ";
    protected static final String SQL_LEFT_JOIN = " LEFT JOIN ";
    protected static final String SQL_INNER_JOIN = " INNER JOIN ";
    protected static final String SQL_WHERE = " WHERE ";
    protected static final String SQL_ORDER_BY = " ORDER BY ";
    protected static final String SQL_GROUP_BY = " GROUP BY ";
    protected static final String SQL_AND = " AND ";
    protected static final String SQL_LIMIT = " LIMIT ";
    protected static final String SQL_DESC = " DESC ";
    protected static final String SQL_REPLACE = " REPLACE INTO ";
    protected static final String SQL_ON_DUP_KEY_UPDATE = " ON DUPLICATE KEY UPDATE ";
    protected static final String SQL_UNION_ALL = " UNION ALL ";
    protected Connection con;

    public static int foundRows(Statement st) throws SQLException {
        int result = -1;
        ResultSet rs = st.executeQuery("SELECT FOUND_ROWS()");
        if (rs.next()) {
            result = rs.getInt(1);
        }
        return result;
    }

    protected CommonDAO() {
    }

    protected CommonDAO(Connection con) {
        this.con = con;
    }

    protected int lastInsertId(PreparedStatement ps) throws SQLException {
        int id = -1;
        ResultSet rs = ps.getGeneratedKeys();
        while (rs.next()) {
            id = rs.getInt(1);
        }
        return id;
    }

    protected int updateOrInsert(String updatePsQuery, String insertPsQuery, Object ... params) throws SQLException {
        int result = 0;
        PreparedQuery pq = new PreparedQuery(this.con, updatePsQuery);
        pq.addObjects(params);
        if (pq.executeUpdate() == 0) {
            pq.close();
            pq = new PreparedQuery(this.con, insertPsQuery);
            pq.addObjects(params);
            pq.executeInsert();
            result = this.lastInsertId(pq.getPrepared());
        }
        pq.close();
        return result;
    }

    protected Set<Integer> getIds(String tableName, String linkColumn, String selectColumn, int id) throws SQLException {
        HashSet<Integer> result = new HashSet<Integer>();
        String query = SQL_SELECT + selectColumn + SQL_FROM + tableName + SQL_WHERE + linkColumn + "=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(rs.getInt(1));
        }
        ps.close();
        return result;
    }

    protected List<Integer> getIds(String tableName, String linkColumn, String selectColumn, String posColumn, int id) throws SQLException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String query = SQL_SELECT + selectColumn + SQL_FROM + tableName + SQL_WHERE + linkColumn + "=?  ORDER BY " + posColumn;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
        }
        return result;
    }

    protected Map<Integer, Set<Integer>> getGroupedIds(String tableName, String linkColumn, String selectColumn) throws SQLException {
        HashMap<Integer, Set<Integer>> result = new HashMap<Integer, Set<Integer>>();
        String query = SQL_SELECT + linkColumn + "," + selectColumn + SQL_FROM + tableName + SQL_ORDER_BY + linkColumn;
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int key = rs.getInt(1);
            int value = rs.getInt(2);
            HashSet<Integer> values = (HashSet<Integer>)result.get(key);
            if (values == null) {
                values = new HashSet<Integer>();
                result.put(key, values);
            }
            values.add(value);
        }
        ps.close();
        return result;
    }

    protected Map<Integer, List<Integer>> getGroupedIds(String tableName, String linkColumn, String selectColumn, String posColumn) throws SQLException {
        HashMap<Integer, List<Integer>> result = new HashMap<Integer, List<Integer>>();
        String query = SQL_SELECT + linkColumn + "," + selectColumn + SQL_FROM + tableName + SQL_ORDER_BY + linkColumn + ", " + posColumn + ", " + selectColumn;
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int key = rs.getInt(1);
            int value = rs.getInt(2);
            ArrayList<Integer> values = (ArrayList<Integer>)result.get(key);
            if (values == null) {
                values = new ArrayList<Integer>();
                result.put(key, values);
            }
            values.add(value);
        }
        ps.close();
        return result;
    }

    protected <T> T getById(String tableName, int id, ObjectExtractor<T> extractor) throws SQLException {
        T result = null;
        String query = SQL_SELECT_ALL_FROM + tableName + " WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = extractor.extract(rs);
        }
        ps.close();
        return result;
    }

    protected void deleteById(String tableName, int id) throws SQLException {
        String query = SQL_DELETE_FROM + tableName + " WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.executeUpdate();
        ps.close();
    }

    protected <T extends Id> void update(T record, RecordUpdater<T> updater) throws SQLException {
        PreparedStatement ps = null;
        if (record.getId() <= 0) {
            ps = this.con.prepareStatement(updater.getInsertQuery(), 1);
        } else {
            Pair<String, Integer> updateQuery = updater.getUpdateQuery();
            if (updateQuery != null) {
                ps = this.con.prepareStatement(updateQuery.getFirst());
                ps.setInt(updateQuery.getSecond(), record.getId());
            }
        }
        updater.fillCommonFields(record, ps);
        ps.executeUpdate();
        if (record.getId() <= 0) {
            record.setId(SQLUtils.lastInsertId(ps));
        }
        ps.close();
    }

    protected void updateIds(String tableName, String linkColumn, String valueColumn, Object id, Set<Integer> values) throws SQLException {
        String query = SQL_DELETE_FROM + tableName + SQL_WHERE + linkColumn + "=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setObject(1, id);
        ps.executeUpdate();
        ps.close();
        query = SQL_INSERT_INTO + tableName + "(" + linkColumn + "," + valueColumn + ") VALUES (?, ?)";
        ps = this.con.prepareStatement(query);
        ps.setObject(1, id);
        for (Integer paramId : values) {
            ps.setInt(2, paramId);
            ps.executeUpdate();
        }
        ps.close();
    }

    protected void updateIds(String tableName, String linkColumn, String valueColumn, String posColumn, int id, List<Integer> values) throws SQLException {
        String query = SQL_DELETE_FROM + tableName + SQL_WHERE + linkColumn + "=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.executeUpdate();
        ps.close();
        int pos = 1;
        query = SQL_INSERT_INTO + tableName + "(" + linkColumn + "," + valueColumn + "," + posColumn + ") VALUES (?, ?, ?)";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        for (Integer paramId : values) {
            ps.setInt(2, paramId);
            ps.setInt(3, pos++);
            ps.executeUpdate();
        }
        ps.close();
    }

    protected void updateColumn(String tableName, int id, String columnName, String value) throws SQLException {
        String query = SQL_UPDATE + tableName + " SET `" + columnName + "`=? WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setString(1, value);
        ps.setInt(2, id);
        ps.executeUpdate();
        ps.close();
    }

    @Deprecated
    protected String getPageLimit(Page page) {
        this.log.warndMethod("getPageLimit", "Page.getLimitSql");
        return page.getLimitSql();
    }

    @Deprecated
    protected void setRecordCount(Page page, PreparedStatement ps) throws SQLException {
        this.log.warndMethod("setRecordCount", "Page.setRecordCount");
        if (page != null) {
            page.setRecordCount(ps);
        }
    }

    @Deprecated
    protected String getPeriodSql(Period period, String fieldName) {
        this.log.warndMethod("getPeriodSql", null);
        StringBuilder sql = new StringBuilder();
        if (period != null && fieldName != null) {
            if (period.getDateFrom() != null) {
                sql.append(SQL_AND);
                sql.append(fieldName);
                sql.append(" >= ? ");
            }
            if (period.getDateTo() != null) {
                sql.append(SQL_AND);
                sql.append(fieldName);
                sql.append(" <= ? ");
            }
        }
        return sql.toString();
    }

    @Deprecated
    protected int setPeriodParamValue(Period period, PreparedStatement ps, int index) throws SQLException {
        this.log.warndMethod("setPeriodParamValue", null);
        if (period != null && ps != null) {
            if (period.getDateFrom() != null) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate(period.getDateFrom()));
            }
            if (period.getDateTo() != null) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate(period.getDateTo()));
            }
        }
        return index;
    }

    protected static interface ObjectExtractor<T> {
        public T extract(ResultSet var1) throws SQLException;
    }

    protected abstract class RecordUpdater<T extends Id> {
        protected RecordUpdater(CommonDAO this$0) {
        }

        public abstract String getInsertQuery() throws SQLException;

        public Pair<String, Integer> getUpdateQuery() throws SQLException {
            return null;
        }

        public abstract void fillCommonFields(T var1, PreparedStatement var2) throws SQLException;
    }
}

