/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.svc.log.action.admin;

import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.model.Pageable;
import org.bgerp.plugin.svc.log.dao.ActionLogDAO;
import org.bgerp.plugin.svc.log.model.ActionLogEntry;
import org.bgerp.util.TimeConvert;
import ru.bgcrm.model.user.PermissionNode;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/admin/plugin/log/action")
public class ActionLogAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/admin/plugin/log";

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        form.setRequestAttribute("permTrees", PermissionNode.getPermissionTrees());
        return this.html(conSet, form, "/WEB-INF/jspf/admin/plugin/log/action.jsp");
    }

    public ActionForward search(DynActionForm form, ConnectionSet conSet) throws Exception {
        Date timeFrom = form.getParamDateTime("timeFrom");
        if (timeFrom == null) {
            throw new BGMessageException("Time from can't be empty.", new Object[0]);
        }
        Date timeTo = form.getParamDateTime("timeTo");
        if (timeTo != null && !TimeConvert.toYearMonth(timeFrom).equals(TimeConvert.toYearMonth(timeTo))) {
            throw new BGMessageException("Time to must be in the same month as time from.", new Object[0]);
        }
        Set<String> actions = form.getParamValuesStr("perm");
        TreeSet<String> allActions = new TreeSet<String>(actions);
        for (String action : actions) {
            allActions.addAll(PermissionNode.getPermissionNodeOrThrow(action).getActions());
        }
        new ActionLogDAO(conSet.getSlaveConnection()).withTimeFrom(timeFrom).withTimeTo(timeTo).withIpAddress(form.getParam("ipAddress")).withParameter(form.getParam("parameter")).withUserIds(form.getParamValues("userId")).withActions(allActions).search(new Pageable<ActionLogEntry>(form));
        return this.unspecified(form, conSet);
    }
}

