/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.callboard.model.work;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bgerp.plugin.pln.callboard.model.WorkTask;
import org.bgerp.plugin.pln.callboard.model.WorkType;
import org.bgerp.plugin.pln.callboard.model.WorkTypeTime;
import org.bgerp.plugin.pln.callboard.model.work.SlotRange;
import org.bgerp.util.Log;

public class CellRange {
    private static final Log log = Log.getLog();
    public final WorkType workType;
    public final WorkTypeTime workTypeTime;
    int cells;
    private final int slotCount;
    List<WorkTask> taskList = new ArrayList<WorkTask>();

    CellRange(WorkType workType, WorkTypeTime workTypeTime, int cells) {
        this.workType = workType;
        this.workTypeTime = workTypeTime;
        this.cells = cells;
        this.slotCount = workType != null ? workType.getSlotCount(workTypeTime.getDayMinuteFrom(), workTypeTime.getDayMinuteTo()) : 1;
    }

    public WorkType getWorkType() {
        return this.workType;
    }

    public WorkTypeTime getWorkTypeTime() {
        return this.workTypeTime;
    }

    public int getCells() {
        return this.cells;
    }

    public List<SlotRange> getSlotRanges() {
        ArrayList<SlotRange> result = new ArrayList<SlotRange>();
        if (this.workTypeTime != null) {
            Iterator<WorkTask> taskIterator = this.taskList.iterator();
            SlotRange currentRange = null;
            WorkTask currentTask = null;
            for (int slot = 0; slot < this.slotCount; ++slot) {
                if (currentTask == null || currentTask.getSlotTo() <= slot) {
                    WorkTask workTask = currentTask = taskIterator.hasNext() ? taskIterator.next() : null;
                }
                if (currentTask != null && currentTask.getSlotFrom() <= slot && slot < currentTask.getSlotTo()) {
                    if (currentRange == null || currentRange.task != currentTask) {
                        currentRange = new SlotRange(currentTask, slot, 1);
                        result.add(currentRange);
                        continue;
                    }
                    ++currentRange.slotCount;
                    continue;
                }
                result.add(new SlotRange(null, slot, 1));
            }
        }
        return result;
    }

    public int getDayMinuteFrom(SlotRange slotRange) {
        return this.workTypeTime.getDayMinuteFrom() + slotRange.slotFrom * this.workType.getTimeSetStep();
    }

    public List<int[]> getFreeSlotRanges() {
        ArrayList<int[]> rangeList = new ArrayList<int[]>();
        int[] currentRange = null;
        for (SlotRange pair : this.getSlotRanges()) {
            log.debug("SlotRange from: {}; count: {} task: {}", pair.slotFrom, pair.slotCount, pair.task);
            if (pair.task != null) {
                currentRange = null;
                continue;
            }
            if (currentRange == null) {
                currentRange = new int[]{pair.slotFrom, pair.slotFrom};
                rangeList.add(currentRange);
                continue;
            }
            currentRange[1] = pair.slotFrom;
        }
        return rangeList;
    }
}

