/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bil.invoice.num;

import java.sql.Connection;
import java.text.DecimalFormat;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.plugin.bil.invoice.dao.InvoiceNumberDAO;
import org.bgerp.plugin.bil.invoice.model.Invoice;
import org.bgerp.plugin.bil.invoice.model.InvoiceType;
import org.bgerp.plugin.bil.invoice.num.NumberProvider;
import org.bgerp.util.Log;
import ru.bgcrm.util.PatternFormatter;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class PatternBasedNumberProvider
extends NumberProvider {
    private static final Log log = Log.getLog();
    private final String pattern;

    protected PatternBasedNumberProvider(ConfigMap config) {
        super(null);
        this.pattern = config.get("pattern", "");
    }

    @Override
    public void number(Connection con, InvoiceType type, Invoice invoice) throws Exception {
        InvoiceNumberDAO cnt = new InvoiceNumberDAO(con, invoice);
        String number = PatternFormatter.processPattern(this.pattern, var -> {
            try {
                if (var.startsWith("process_id")) {
                    String format = StringUtils.substringAfter((String)var, (String)":");
                    if (Utils.notBlankString(format)) {
                        return new DecimalFormat(format).format(invoice.getProcessId());
                    }
                    return String.valueOf(invoice.getProcessId());
                }
                if (var.startsWith("date_from")) {
                    String format = StringUtils.substringAfter((String)var, (String)":");
                    if (Utils.notBlankString(format)) {
                        return TimeUtils.format(invoice.getDateFrom(), format);
                    }
                    return TimeUtils.format(invoice.getDateFrom(), "ymd");
                }
                if (var.startsWith("date_to")) {
                    String format = StringUtils.substringAfter((String)var, (String)":");
                    if (Utils.notBlankString(format)) {
                        return TimeUtils.format(invoice.getDateTo(), format);
                    }
                    return TimeUtils.format(invoice.getDateTo(), "ymd");
                }
                if (var.startsWith("number_in_month_for_process")) {
                    invoice.setNumberCnt(cnt.month().process().next());
                    String format = StringUtils.substringAfter((String)var, (String)":");
                    if (Utils.notBlankString(format)) {
                        return new DecimalFormat(format).format(invoice.getNumberCnt());
                    }
                    return String.valueOf(invoice.getNumberCnt());
                }
            }
            catch (Exception e) {
                log.error(e);
            }
            return "";
        });
        invoice.setNumber(number);
    }
}

