/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bil.invoice.model;

import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.bean.Bean;
import org.bgerp.app.servlet.jsp.GetJsp;
import org.bgerp.model.base.IdTitle;
import org.bgerp.plugin.bil.invoice.model.Invoice;
import org.bgerp.plugin.bil.invoice.num.NumberProvider;
import org.bgerp.plugin.bil.invoice.num.PatternBasedNumberProvider;
import org.bgerp.plugin.bil.invoice.pos.PositionProvider;
import org.bgerp.util.TimeConvert;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.sql.ConnectionSet;

public class InvoiceType
extends IdTitle
implements GetJsp {
    private static final Map<String, String> TEMPLATE_JSP = Map.of("eu_en", "/WEB-INF/jspf/user/plugin/invoice/doc/eu_en.jsp", "ru_ru", "/WEB-INF/jspf/user/plugin/invoice/doc/ru_ru.jsp");
    private final NumberProvider numberProvider;
    private final int customerId;
    private final List<PositionProvider> providers;
    private final String jsp;

    public InvoiceType(int id, ConfigMap config) throws Exception {
        super(id, config.get("title", "??? [" + id + "]"));
        this.numberProvider = this.loadNumberProvider(config.sub("number."));
        this.customerId = config.getInt("customer");
        this.providers = this.loadPositionProviders(config);
        this.jsp = this.loadJsp(config);
    }

    private NumberProvider loadNumberProvider(ConfigMap config) throws Exception {
        Class<?> clazz = Bean.getClass(config.get("class", PatternBasedNumberProvider.class.getName()));
        return (NumberProvider)config.getConfig(clazz);
    }

    private List<PositionProvider> loadPositionProviders(ConfigMap config) throws Exception {
        ArrayList<PositionProvider> result = new ArrayList<PositionProvider>();
        for (ConfigMap providerConfig : config.subIndexed("provider.").values()) {
            Class<?> clazz = Bean.getClass(providerConfig.get("class"));
            result.add((PositionProvider)providerConfig.getConfig(clazz));
        }
        return Collections.unmodifiableList(result);
    }

    private String loadJsp(ConfigMap config) throws Exception {
        return config.getSok(TEMPLATE_JSP.get(config.get("template", "eu_en")), false, "template.jsp", "jsp");
    }

    public Invoice invoice(ConnectionSet conSet, int processId, YearMonth monthFrom, YearMonth monthTo) throws Exception {
        Invoice result = new Invoice();
        result.setTypeId(this.id);
        result.setProcessId(processId);
        result.setDateFrom(TimeConvert.toDate(monthFrom));
        result.setDateTo(TimeUtils.getEndMonth(TimeConvert.toDate(monthTo)));
        for (PositionProvider provider : this.providers) {
            provider.addPositions(conSet, result);
        }
        result.amount();
        return result;
    }

    public NumberProvider getNumberProvider() {
        return this.numberProvider;
    }

    public int getCustomerId() {
        return this.customerId;
    }

    @Override
    public String getJsp() {
        return this.jsp;
    }
}

