/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.process;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.cache.ParameterCache;
import org.bgerp.model.Pageable;
import org.bgerp.model.param.Parameter;
import org.bgerp.model.process.queue.Column;
import org.bgerp.model.process.queue.filter.Filter;
import org.bgerp.model.process.queue.filter.FilterCustomerParam;
import org.bgerp.model.process.queue.filter.FilterGrEx;
import org.bgerp.model.process.queue.filter.FilterLinkObject;
import org.bgerp.model.process.queue.filter.FilterList;
import org.bgerp.model.process.queue.filter.FilterOpenClose;
import org.bgerp.model.process.queue.filter.FilterParam;
import org.bgerp.model.process.queue.filter.FilterProcessType;
import org.bgerp.util.sql.LikePattern;
import ru.bgcrm.dao.ParamValueSelect;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.dao.process.QueueSelectParams;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.param.ParameterAddressValue;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.queue.Queue;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.AddressUtils;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class ProcessQueueDAO
extends ProcessDAO {
    public static final String LINKED_PROCESS_JOIN = " LEFT JOIN  process_link  AS pllp ON pllp.object_id=process.id AND pllp.object_type LIKE 'process%'  LEFT JOIN  process  AS linked ON pllp.process_id=linked.id";

    public ProcessQueueDAO(Connection con) {
        super(con);
    }

    public ProcessQueueDAO(Connection con, DynActionForm form) {
        super(con, form);
    }

    public void searchProcess(Pageable<Object[]> searchResult, List<String> aggregatedValues, Queue queue, DynActionForm form) throws Exception {
        QueueSelectParams params = this.prepareQueueSelect(queue);
        this.addFilters(params.queue, form, params);
        String orders = queue.getSortSet().getOrders(form);
        Page page = searchResult.getPage();
        StringBuilder query = new StringBuilder(1000);
        query.append("SELECT DISTINCT SQL_CALC_FOUND_ROWS ");
        query.append((CharSequence)params.selectPart);
        query.append(" FROM  process  AS process");
        query.append((CharSequence)params.joinPart);
        query.append((CharSequence)params.wherePart);
        if (Utils.notBlankString(orders)) {
            query.append(" ORDER BY ");
            query.append(orders);
        }
        query.append(page.getLimitSql());
        this.log.debug(query.toString(), new Object[0]);
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        boolean selectLinked = params.joinPart.indexOf(LINKED_PROCESS_JOIN) > 0;
        List<Object[]> list = searchResult.getList();
        int columns = params.queue.getColumnList().size();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Process process = ProcessQueueDAO.getProcessFromRs(rs, "process.");
            Process linkedProcess = selectLinked ? ProcessQueueDAO.getProcessFromRs(rs, "linked.") : null;
            Object[] row = new Object[columns + 1];
            row[0] = new Process[]{process, linkedProcess};
            for (int i = 1; i <= columns; ++i) {
                row[i] = rs.getObject(i);
            }
            list.add(row);
        }
        if (page != null) {
            page.setRecordCount(ps);
        }
        ps.close();
        this.loadFormattedAddressParamValues(searchResult, queue);
        if (aggregatedValues != null && params.selectAggregatePart != null) {
            this.selectAggregatedValues(aggregatedValues, params, columns);
        }
    }

    protected QueueSelectParams prepareQueueSelect(Queue queue) throws Exception {
        QueueSelectParams result = new QueueSelectParams();
        result.queue = queue;
        result.selectPart = new StringBuilder("");
        result.joinPart = new StringBuilder();
        result.wherePart = new StringBuilder(" WHERE ");
        result.wherePart.append("process.type_id IN (");
        result.wherePart.append(Utils.toString(queue.getProcessTypeIds(), "-1", ","));
        result.wherePart.append(") AND process.id>0");
        boolean hasAggregateColumns = this.addColumns(queue, result.selectPart, result.joinPart, false);
        if (hasAggregateColumns) {
            result.selectAggregatePart = new StringBuilder();
            this.addColumns(queue, result.selectAggregatePart, new StringBuilder(), true);
            result.selectAggregatePart.append("0");
        }
        result.selectPart.append("process.*");
        if (result.joinPart.indexOf(LINKED_PROCESS_JOIN) > 0) {
            result.selectPart.append(",linked.*");
        }
        result.joinPart.append(ProcessQueueDAO.getIsolationJoin(this.form, "process"));
        return result;
    }

    private void loadFormattedAddressParamValues(Pageable<Object[]> searchResult, Queue queue) throws SQLException {
        List<Column> columnList = queue.getColumnList();
        int length = columnList.size();
        for (int i = 0; i < length; ++i) {
            String formatName;
            int paramId;
            Column col = columnList.get(i);
            String value = col.getValue();
            if (!value.startsWith("param:") || (paramId = Utils.parseInt(StringUtils.substringBetween((String)value, (String)":"))) <= 0) continue;
            Parameter param = ParameterCache.getParameter(paramId);
            if (param == null) {
                this.log.warn("Queue: " + queue.getId() + "; incorrect column expression, param not found: " + value, new Object[0]);
                continue;
            }
            if (!"address".equals(param.getType()) || ParamValueSelect.PARAM_ADDRESS_FIELDS.contains(formatName = StringUtils.substringAfterLast((String)value, (String)":"))) continue;
            for (Object[] row : searchResult.getList()) {
                StringBuilder newValue = new StringBuilder(100);
                if (row[i + 1] == null) continue;
                for (String token : Utils.maskNull(row[i + 1].toString()).split("\\|")) {
                    String[] addressData = token.split(":", -1);
                    ParameterAddressValue addrValue = new ParameterAddressValue();
                    addrValue.setHouseId(Utils.parseInt(addressData[0]));
                    addrValue.setFlat(addressData[1]);
                    addrValue.setRoom(addressData[2]);
                    addrValue.setPod(Utils.parseInt(addressData[3]));
                    addrValue.setFloor(Utils.parseInt(addressData[4]));
                    addrValue.setComment(addressData[5]);
                    Utils.addSeparated(newValue, "; ", AddressUtils.buildAddressValue(addrValue, this.con, formatName));
                }
                row[i + 1] = newValue.toString();
            }
        }
    }

    private void selectAggregatedValues(List<String> aggregateValues, QueueSelectParams params, int columns) throws SQLException {
        StringBuilder query = new StringBuilder(100);
        query.append("SELECT ");
        query.append((CharSequence)params.selectAggregatePart);
        query.append(" FROM  process  AS process");
        query.append((CharSequence)params.joinPart);
        query.append((CharSequence)params.wherePart);
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            for (int i = 0; i < columns; ++i) {
                aggregateValues.add(rs.getString(i + 1));
            }
        }
        ps.close();
        this.log.debug("Aggregated values: {}", aggregateValues);
    }

    public String getCountQuery(Queue queue, DynActionForm form) throws Exception {
        QueueSelectParams params = this.prepareQueueSelect(queue);
        this.addFilters(params.queue, form, params);
        StringBuilder query = new StringBuilder();
        query.append("SELECT COUNT(DISTINCT process.id) ");
        query.append(" FROM  process  AS process");
        query.append((CharSequence)params.joinPart);
        query.append((CharSequence)params.wherePart);
        return query.toString();
    }

    protected void addFilters(Queue queue, DynActionForm form, QueueSelectParams params) {
        StringBuilder joinPart = params.joinPart;
        StringBuilder wherePart = params.wherePart;
        FilterList filterList = queue.getFilterList();
        for (Filter f : filterList.getFilterList()) {
            String type = f.getType();
            if ("groups".equals(type)) {
                Filter filter = f;
                String groupIds = Utils.toString(form.getParamValues("group"));
                if (Utils.isBlankString(groupIds) && filter.getOnEmptyValues().size() > 0) {
                    groupIds = Utils.toString(filter.getOnEmptyValues());
                }
                if (!Utils.notBlankString(groupIds)) continue;
                joinPart.append(" INNER JOIN ");
                joinPart.append(" process_group ");
                joinPart.append("AS ig ON process.id=ig.process_id AND ig.group_id IN(");
                joinPart.append(groupIds);
                joinPart.append(")");
                continue;
            }
            if ("executors".equals(type)) {
                Filter filter = f;
                Set<String> executorIds = form.getParamValuesStr("executor");
                if (executorIds.contains("current")) {
                    executorIds.remove("current");
                    executorIds.add(String.valueOf(form.getUserId()));
                }
                if (filter.getValues().contains("current")) {
                    executorIds = Collections.singleton(String.valueOf(form.getUserId()));
                }
                boolean includeCreateUser = false;
                if (Utils.parseBoolean(filter.getConfigMap().get("includeCreateUser"))) {
                    includeCreateUser = true;
                }
                if (executorIds.size() <= 0) continue;
                if (executorIds.contains("empty")) {
                    wherePart.append(" AND process.executors=''");
                    continue;
                }
                executorIds.remove("empty");
                String executorIdsStr = Utils.toString(executorIds);
                joinPart.append(" LEFT JOIN ");
                joinPart.append(" process_executor ");
                joinPart.append("AS ie ON process.id=ie.process_id ");
                wherePart.append(" AND ( ie.user_id IN(");
                wherePart.append(executorIdsStr);
                wherePart.append(")");
                if (includeCreateUser) {
                    wherePart.append(" OR process.create_user_id IN(");
                    wherePart.append(executorIdsStr);
                    wherePart.append(")");
                }
                wherePart.append(") ");
                continue;
            }
            if ("create_user".equals(type)) {
                Set<Integer> userIds = form.getParamValues("create_user");
                if (userIds.isEmpty()) continue;
                wherePart.append(" AND process.create_user_id IN (").append(Utils.toString(userIds)).append(") ");
                continue;
            }
            if ("close_user".equals(type)) {
                Set<Integer> userIds = form.getParamValues("close_user");
                if (userIds.isEmpty()) continue;
                wherePart.append(" AND process.close_user_id IN (").append(Utils.toString(userIds)).append(") ");
                continue;
            }
            if (f instanceof FilterGrEx) {
                FilterGrEx filter = (FilterGrEx)f;
                filter.apply(form, params);
                continue;
            }
            if (f instanceof FilterProcessType) {
                Filter filter = f;
                String typeIds = Utils.toString(form.getParamValues("type"));
                if (Utils.isBlankString(typeIds) && filter.getOnEmptyValues().size() > 0) {
                    typeIds = Utils.toString(filter.getOnEmptyValues());
                }
                if (!Utils.notBlankString(typeIds)) continue;
                wherePart.append(" AND process.type_id IN (");
                wherePart.append(typeIds);
                wherePart.append(")");
                continue;
            }
            if ("quarter".equals(type)) {
                FilterParam filter = (FilterParam)f;
                int paramId = filter.getParameter().getId();
                String values = Utils.toString(form.getParamValues("quarter"));
                if (!Utils.notBlankString(values)) continue;
                String alias = "param_list_" + paramId;
                joinPart.append(" INNER JOIN ");
                joinPart.append(" param_list ");
                joinPart.append("AS " + alias + " ON process.id=" + alias + ".id AND " + alias + ".param_id=" + paramId + " AND " + alias + ".value IN(" + values + ") ");
                continue;
            }
            if (f instanceof FilterOpenClose) {
                String openCloseFilterValue = form.getParam("openClose", ((FilterOpenClose)f).getDefaultValue());
                if (f.getValues().size() > 0) {
                    openCloseFilterValue = f.getValues().iterator().next();
                }
                if ("open".equals(openCloseFilterValue)) {
                    wherePart.append(" AND process.close_dt IS NULL ");
                    continue;
                }
                if (!"close".equals(openCloseFilterValue)) continue;
                wherePart.append(" AND process.close_dt IS NOT NULL ");
                continue;
            }
            if (f instanceof FilterCustomerParam) {
                FilterCustomerParam filter = (FilterCustomerParam)f;
                int paramId = filter.getParameter().getId();
                String values = Utils.toString(form.getParamValues("param" + paramId + "value"));
                if (Utils.isBlankString(values) && filter.getOnEmptyValues().size() > 0) {
                    values = Utils.toString(filter.getOnEmptyValues());
                }
                if (Utils.isBlankString(values)) continue;
                String customerLinkAlias = "customer_link_" + paramId;
                joinPart.append(" INNER JOIN ");
                joinPart.append(" process_link ");
                joinPart.append("AS " + customerLinkAlias + " ON process.id=" + customerLinkAlias + ".process_id AND " + customerLinkAlias + ".object_type='customer'");
                joinPart.append(" INNER JOIN ");
                joinPart.append(" param_list ");
                joinPart.append("AS param_list ON " + customerLinkAlias + ".object_id=param_list.id AND param_list.param_id=" + paramId + " AND param_list.value IN(" + values + ")");
                continue;
            }
            if (f instanceof FilterParam) {
                FilterParam filter = (FilterParam)f;
                filter.apply(form, params);
                continue;
            }
            if ("status".equals(type)) {
                String statusIds = f.getValues(form, "status");
                if (!Utils.notBlankString(statusIds)) continue;
                wherePart.append(" AND process.status_id IN (");
                wherePart.append(statusIds);
                wherePart.append(")");
                continue;
            }
            if ("create_date".equals(type)) {
                this.addDateFilter(form, wherePart, "dateCreate", "create_dt");
                continue;
            }
            if ("close_date".equals(type)) {
                this.addDateFilter(form, wherePart, "dateClose", "close_dt");
                continue;
            }
            if ("code".equals(type)) {
                int code = Utils.parseInt(form.getParam("code"));
                if (code <= 0) continue;
                wherePart.append(" AND process.id=");
                wherePart.append(code);
                continue;
            }
            if ("description".equals(type)) {
                String description = form.getParam("description");
                if (!Utils.notBlankString(description)) continue;
                wherePart.append(" AND POSITION( '");
                wherePart.append(description);
                wherePart.append("' IN process.description)>0");
                continue;
            }
            if ("status_date".equals(type)) {
                int statusId = form.getParamInt("dateStatusStatus", -1);
                Date dateFrom = TimeUtils.parse(form.getParam("dateStatusFrom"), "ymd");
                Date dateTo = TimeUtils.parse(form.getParam("dateStatusTo"), "ymd");
                if (dateFrom == null && dateTo == null) continue;
                joinPart.append(" INNER JOIN process_status ON process.id=process_status.process_id AND process_status.status_id=");
                joinPart.append(statusId);
                if (dateFrom != null) {
                    joinPart.append(" AND process_status.dt>=" + TimeUtils.formatSqlDate(dateFrom));
                }
                if (dateTo == null) continue;
                joinPart.append(" AND process_status.dt<" + TimeUtils.formatSqlDate(TimeUtils.getNextDay(dateTo)));
                continue;
            }
            if ("linkedCustomer:title".equals(type)) {
                String customerTitle = form.getParam("linkedCustomer:title");
                if (!Utils.notEmptyString(customerTitle)) continue;
                String linkedCustomerAlias = "linked_customer_title_filter_link";
                String customerAlias = "linked_customer_title_filter_customer";
                joinPart.append(" LEFT JOIN ");
                joinPart.append(" process_link ");
                joinPart.append(" AS " + linkedCustomerAlias + " ON process.id=" + linkedCustomerAlias + ".process_id AND " + linkedCustomerAlias + ".object_type LIKE '" + LikePattern.START.get("customer") + "'");
                joinPart.append(" LEFT JOIN ");
                joinPart.append(" customer ");
                joinPart.append(" AS " + customerAlias + " ON " + linkedCustomerAlias + ".object_id=" + customerAlias + ".id ");
                wherePart.append(" AND ");
                wherePart.append(" " + customerAlias + ".title LIKE '%" + customerTitle + "%' ");
                continue;
            }
            if ("linkedObject".equals(type)) {
                ConfigMap configMap = f.getConfigMap();
                String objectTypeMask = configMap.get("objectTypeMask");
                String objectTitleRegExp = configMap.get("objectTitleRegExp");
                boolean notMode = configMap.getBoolean("notMode", false);
                if (Utils.isEmptyString(objectTypeMask) || Utils.isEmptyString(objectTitleRegExp)) continue;
                joinPart.append(" INNER JOIN ");
                joinPart.append(" process_link ");
                joinPart.append("AS linked_object_filter ");
                joinPart.append("ON linked_object_filter.process_id = process.id ");
                joinPart.append("AND linked_object_filter.object_type LIKE '" + objectTypeMask + "' ");
                joinPart.append("AND linked_object_filter.object_title ");
                if (notMode) {
                    joinPart.append("NOT ");
                }
                joinPart.append("REGEXP '" + objectTitleRegExp + "'");
                continue;
            }
            if ("message:systemId".equals(type)) {
                String systemId = form.getParam("message:systemId");
                if (!Utils.notEmptyString(systemId)) continue;
                String messageAlias = "linked_message";
                joinPart.append(" INNER JOIN ");
                joinPart.append(" message ");
                joinPart.append(" AS " + messageAlias + " ON process.id=" + messageAlias + ".process_id ");
                wherePart.append(" AND ");
                wherePart.append(" " + messageAlias + ".system_id = '" + systemId + "' ");
                continue;
            }
            if (!(f instanceof FilterLinkObject)) continue;
            FilterLinkObject filter = (FilterLinkObject)f;
            String value = form.getParam(filter.getParamName());
            if (!filter.getValues().isEmpty()) {
                value = Utils.getFirst(filter.getValues());
            }
            if (!Utils.notBlankString(value)) continue;
            String joinTableName = " link_obj_f_" + filter.getId() + " ";
            joinPart.append(" INNER JOIN ");
            joinPart.append(" process_link ");
            joinPart.append("AS " + joinTableName);
            joinPart.append("ON " + joinTableName + ".process_id=process.id AND " + joinTableName + ".object_type='" + filter.getObjectType() + "' ");
            if ("id".equals(filter.getWhatFilter())) {
                joinPart.append("AND " + joinTableName + ".object_id='" + value + "'");
                continue;
            }
            if ("title".equals(filter.getWhatFilter())) {
                joinPart.append("AND " + joinTableName + ".object_title LIKE '%" + value + "%'");
                continue;
            }
            this.log.error("Incorrect linkObject filter( " + filter.getId() + " )! Not a valid value \"whatFiltered\". ", new Object[0]);
        }
    }

    private void addDateFilter(DynActionForm form, StringBuilder wherePart, String paramPrefix, String column) {
        Date dateFrom = TimeUtils.parse(form.getParam(paramPrefix + "From"), "ymd");
        Date dateTo = TimeUtils.parse(form.getParam(paramPrefix + "To"), "ymd");
        if (dateFrom != null) {
            wherePart.append(" AND process." + column + ">=" + TimeUtils.formatSqlDate(dateFrom));
        }
        if (dateTo != null) {
            wherePart.append(" AND process." + column + "<" + TimeUtils.formatSqlDate(TimeUtils.getNextDay(dateTo)));
        }
    }

    private boolean addColumns(Queue queue, StringBuilder selectPart, StringBuilder joinPart, boolean aggregate) throws Exception {
        StringBuilder selectPartBuffer = new StringBuilder(60);
        boolean aggregateFunctions = false;
        for (Column col : queue.getColumnList()) {
            String aggregateFunction = col.getAggregate();
            boolean hasAggregateFunction = Utils.notBlankString(aggregateFunction);
            boolean bl = aggregateFunctions = aggregateFunctions || hasAggregateFunction;
            if (aggregate) {
                if (hasAggregateFunction) {
                    selectPartBuffer.setLength(0);
                    selectPartBuffer.append(aggregateFunction);
                    selectPartBuffer.append("(");
                    int lengthBefore = selectPartBuffer.length();
                    col.addQuery(selectPartBuffer, joinPart);
                    if (selectPartBuffer.length() == lengthBefore) continue;
                    int pos = selectPartBuffer.lastIndexOf(",");
                    selectPart.append(selectPartBuffer.substring(0, pos - 1));
                    selectPart.append(")");
                    selectPart.append(selectPartBuffer.substring(pos));
                    continue;
                }
                selectPart.append("NULL,");
                continue;
            }
            col.addQuery(selectPart, joinPart);
        }
        return aggregateFunctions;
    }
}

