/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.action;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.asteriskjava.manager.action.AbstractManagerAction;
import org.asteriskjava.manager.action.EventGeneratingAction;
import org.asteriskjava.manager.action.VariableInheritance;
import org.asteriskjava.manager.event.OriginateResponseEvent;
import org.asteriskjava.manager.event.ResponseEvent;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class OriginateAction
extends AbstractManagerAction
implements EventGeneratingAction {
    private final Log logger = LogFactory.getLog(this.getClass());
    static final long serialVersionUID = 8194597741743334704L;
    private String channel;
    private String exten;
    private String context;
    private Integer priority;
    private Long timeout;
    private String callerId;
    private Integer callingPres;
    private Map<String, String> variables;
    private String account;
    private String application;
    private String data;
    private Boolean async;
    private String codecs;
    private Boolean earlyMedia;
    private String channelId;
    private String otherChannelId;
    private int headerCounter = 10;
    private Set<String> preventDuplicateSipHeaders = new HashSet<String>();

    @Override
    public String getAction() {
        return "Originate";
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getCallerId() {
        return this.callerId;
    }

    public void setCallerId(String callerId) {
        this.callerId = callerId;
    }

    public Integer getCallingPres() {
        return this.callingPres;
    }

    public void setCallingPres(Integer callingPres) {
        this.callingPres = callingPres;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getExten() {
        return this.exten;
    }

    public void setExten(String exten) {
        this.exten = exten;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    @Deprecated
    public void setTimeout(Integer timeout) {
        if (timeout != null) {
            if (timeout < 1000) {
                this.logger.error("A timeout of 1000 will cause the originate to almost cretainly fail!");
            }
            if (timeout < 10000) {
                this.logger.warn("A timeout of less than 10000 will cause the originate to fail if not answered within 10 seconds!");
            }
            this.timeout = timeout.longValue();
        } else {
            this.timeout = null;
        }
    }

    public void setTimeout(Long timeout) {
        if (timeout != null) {
            if (timeout < 1000L) {
                this.logger.error("A timeout of 1000 will cause the originate to almost cretainly fail!");
            }
            if (timeout < 10000L) {
                this.logger.warn("A timeout of less than 100000 will cause the originate to fail if not answered within 10 seconds!");
            }
        }
        this.timeout = timeout;
    }

    @Deprecated
    public void setVariable(String variable) {
        if (variable == null) {
            this.variables = null;
            return;
        }
        StringTokenizer st = new StringTokenizer(variable, "|");
        this.variables = new LinkedHashMap<String, String>();
        while (st.hasMoreTokens()) {
            String[] keyValue = st.nextToken().split("=", 2);
            if (keyValue.length < 2) {
                this.variables.put(keyValue[0], null);
                continue;
            }
            this.variables.put(keyValue[0], keyValue[1]);
        }
    }

    public void setVariable(String name, String value) {
        if (this.variables == null) {
            this.variables = new LinkedHashMap<String, String>();
        }
        this.variables.put(name, value);
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        if (this.variables != null) {
            this.variables.putAll(variables);
        } else {
            this.variables = variables;
        }
    }

    public Boolean getAsync() {
        return this.async;
    }

    public void setAsync(Boolean async) {
        this.async = async;
    }

    public void setEarlyMedia(Boolean earlyMedia) {
        this.earlyMedia = earlyMedia;
    }

    public Boolean getEarlyMedia() {
        return this.earlyMedia;
    }

    public String getCodecs() {
        return this.codecs;
    }

    public void setCodecs(String codecs) {
        this.codecs = codecs;
    }

    public void setCodecs(List<String> codecs) {
        if (codecs == null || codecs.isEmpty()) {
            this.codecs = null;
            return;
        }
        Iterator<String> iter = codecs.iterator();
        StringBuilder buffer = new StringBuilder(iter.next());
        while (iter.hasNext()) {
            buffer.append(",").append(iter.next());
        }
        this.codecs = buffer.toString();
    }

    @Override
    public Class<? extends ResponseEvent> getActionCompleteEventClass() {
        return OriginateResponseEvent.class;
    }

    public void addSipHeader(VariableInheritance inheritance, String header) {
        if (!this.preventDuplicateSipHeaders.contains(header)) {
            this.setVariable(inheritance.getPrefix() + "SIPADDHEADER" + this.headerCounter++, header);
            this.preventDuplicateSipHeaders.add(header);
            if (this.headerCounter > 50) {
                this.logger.warn("I think only 50 headers are allowed by asterisk?");
            }
        } else {
            this.logger.error("Already added the sip header " + header);
        }
    }

    public void addPjSipHeader(VariableInheritance inheritance, String header) {
        String[] parts;
        if (header != null && (parts = header.split(":")).length == 2) {
            String varName = "PJSIP_HEADER(add," + parts[0] + ")";
            String varValue = parts[1];
            if (!this.preventDuplicateSipHeaders.contains(header)) {
                this.setVariable(varName, varValue);
                this.preventDuplicateSipHeaders.add(header);
            } else {
                this.logger.error("Already added the sip header " + header);
            }
        }
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setOtherChannelId(String otherChannelId) {
        this.otherChannelId = otherChannelId;
    }

    public String getOtherChannelId() {
        return this.otherChannelId;
    }
}

