/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRStyledTextParser;

public abstract class JRStyledTextAttributeSelector {
    protected final JasperReportsContext jasperReportsContext;

    protected JRStyledTextAttributeSelector(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    private static Locale getLocale() {
        return JRStyledTextParser.getLocale();
    }

    public static Locale getTextLocale(JRPrintText printText) {
        String localeCode = printText.getLocaleCode();
        if (localeCode == null) {
            return JRStyledTextAttributeSelector.getLocale();
        }
        return JRDataUtils.getLocale(localeCode);
    }

    public abstract Map<AttributedCharacterIterator.Attribute, Object> getStyledTextAttributes(JRPrintText var1);

    public static JRStyledTextAttributeSelector getAllSelector(JasperReportsContext jasperReportsContext) {
        return new AllSelector(jasperReportsContext);
    }

    public static JRStyledTextAttributeSelector getNoBackcolorSelector(JasperReportsContext jasperReportsContext) {
        return new NoBackcolorSelector(jasperReportsContext);
    }

    public static JRStyledTextAttributeSelector getNoneSelector(JasperReportsContext jasperReportsContext) {
        return new NoneSelector(jasperReportsContext);
    }

    private static class AllSelector
    extends JRStyledTextAttributeSelector {
        public AllSelector(JasperReportsContext jasperReportsContext) {
            super(jasperReportsContext);
        }

        @Override
        public Map<AttributedCharacterIterator.Attribute, Object> getStyledTextAttributes(JRPrintText printText) {
            HashMap<AttributedCharacterIterator.Attribute, Object> attributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
            FontUtil.getInstance(this.jasperReportsContext).getAttributesWithoutAwtFont(attributes, printText);
            attributes.put(TextAttribute.FOREGROUND, printText.getForecolor());
            if (printText.getModeValue() == ModeEnum.OPAQUE) {
                attributes.put(TextAttribute.BACKGROUND, printText.getBackcolor());
            }
            return attributes;
        }
    }

    private static class NoBackcolorSelector
    extends JRStyledTextAttributeSelector {
        public NoBackcolorSelector(JasperReportsContext jasperReportsContext) {
            super(jasperReportsContext);
        }

        @Override
        public Map<AttributedCharacterIterator.Attribute, Object> getStyledTextAttributes(JRPrintText printText) {
            HashMap<AttributedCharacterIterator.Attribute, Object> attributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
            FontUtil.getInstance(this.jasperReportsContext).getAttributesWithoutAwtFont(attributes, printText);
            attributes.put(TextAttribute.FOREGROUND, printText.getForecolor());
            return attributes;
        }
    }

    private static class NoneSelector
    extends JRStyledTextAttributeSelector {
        public NoneSelector(JasperReportsContext jasperReportsContext) {
            super(jasperReportsContext);
        }

        @Override
        public Map<AttributedCharacterIterator.Attribute, Object> getStyledTextAttributes(JRPrintText printText) {
            return null;
        }
    }
}

