/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort.actions;

import java.util.UUID;
import net.sf.jasperreports.components.sort.actions.SortCommand;
import net.sf.jasperreports.components.sort.actions.SortData;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.repo.JasperDesignCache;
import net.sf.jasperreports.web.actions.AbstractAction;
import net.sf.jasperreports.web.actions.ActionException;
import net.sf.jasperreports.web.commands.CommandException;
import net.sf.jasperreports.web.commands.CommandStack;
import net.sf.jasperreports.web.commands.CommandTarget;
import net.sf.jasperreports.web.commands.ResetInCacheCommand;

public class SortAction
extends AbstractAction {
    private static final long serialVersionUID = 10200L;
    private SortData sortData;

    public SortData getSortData() {
        return this.sortData;
    }

    public void setSortData(SortData sortData) {
        this.sortData = sortData;
    }

    @Override
    public void performAction() throws ActionException {
        CommandTarget target;
        if (this.sortData != null && (target = this.getCommandTarget(UUID.fromString(this.sortData.getTableUuid()))) != null) {
            JasperDesignCache cache = JasperDesignCache.getInstance(this.getJasperReportsContext(), this.getReportContext());
            JasperDesign jasperDesign = cache.getJasperDesign(target.getUri());
            JRDesignDataset dataset = (JRDesignDataset)jasperDesign.getMainDataset();
            CommandStack commandStack = this.getCommandStack();
            try {
                commandStack.execute(new ResetInCacheCommand(new SortCommand(this.getJasperReportsContext(), dataset, this.sortData), this.getJasperReportsContext(), this.getReportContext(), target.getUri()));
            }
            catch (CommandException e) {
                throw new ActionException(e);
            }
        }
    }
}

