/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InputTextMessageContent
implements InputMessageContent {
    private static final String MESSAGETEXT_FIELD = "message_text";
    private static final String PARSEMODE_FIELD = "parse_mode";
    private static final String DISABLEWEBPAGEPREVIEW_FIELD = "disable_web_page_preview";
    private static final String ENTITIES_FIELD = "entities";
    @JsonProperty(value="message_text")
    @NonNull
    private String messageText;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="disable_web_page_preview")
    private Boolean disableWebPagePreview;
    @JsonProperty(value="entities")
    private List<MessageEntity> entities;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.messageText == null || this.messageText.isEmpty()) {
            throw new TelegramApiValidationException("MessageText parameter can't be empty", this);
        }
        if (this.parseMode != null && this.entities != null && !this.entities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
    }

    public static InputTextMessageContentBuilder builder() {
        return new InputTextMessageContentBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputTextMessageContent)) {
            return false;
        }
        InputTextMessageContent other = (InputTextMessageContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$disableWebPagePreview = this.getDisableWebPagePreview();
        Boolean other$disableWebPagePreview = other.getDisableWebPagePreview();
        if (this$disableWebPagePreview == null ? other$disableWebPagePreview != null : !((Object)this$disableWebPagePreview).equals(other$disableWebPagePreview)) {
            return false;
        }
        String this$messageText = this.getMessageText();
        String other$messageText = other.getMessageText();
        if (this$messageText == null ? other$messageText != null : !this$messageText.equals(other$messageText)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$entities = this.getEntities();
        List<MessageEntity> other$entities = other.getEntities();
        return !(this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputTextMessageContent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $disableWebPagePreview = this.getDisableWebPagePreview();
        result = result * 59 + ($disableWebPagePreview == null ? 43 : ((Object)$disableWebPagePreview).hashCode());
        String $messageText = this.getMessageText();
        result = result * 59 + ($messageText == null ? 43 : $messageText.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $entities = this.getEntities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        return result;
    }

    @NonNull
    public String getMessageText() {
        return this.messageText;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public Boolean getDisableWebPagePreview() {
        return this.disableWebPagePreview;
    }

    public List<MessageEntity> getEntities() {
        return this.entities;
    }

    @JsonProperty(value="message_text")
    public void setMessageText(@NonNull String messageText) {
        if (messageText == null) {
            throw new NullPointerException("messageText is marked non-null but is null");
        }
        this.messageText = messageText;
    }

    @JsonProperty(value="parse_mode")
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="disable_web_page_preview")
    public void setDisableWebPagePreview(Boolean disableWebPagePreview) {
        this.disableWebPagePreview = disableWebPagePreview;
    }

    @JsonProperty(value="entities")
    public void setEntities(List<MessageEntity> entities) {
        this.entities = entities;
    }

    public String toString() {
        return "InputTextMessageContent(messageText=" + this.getMessageText() + ", parseMode=" + this.getParseMode() + ", disableWebPagePreview=" + this.getDisableWebPagePreview() + ", entities=" + this.getEntities() + ")";
    }

    public InputTextMessageContent(@NonNull String messageText) {
        if (messageText == null) {
            throw new NullPointerException("messageText is marked non-null but is null");
        }
        this.messageText = messageText;
    }

    public InputTextMessageContent() {
    }

    public InputTextMessageContent(@NonNull String messageText, String parseMode, Boolean disableWebPagePreview, List<MessageEntity> entities) {
        if (messageText == null) {
            throw new NullPointerException("messageText is marked non-null but is null");
        }
        this.messageText = messageText;
        this.parseMode = parseMode;
        this.disableWebPagePreview = disableWebPagePreview;
        this.entities = entities;
    }

    public static class InputTextMessageContentBuilder {
        private String messageText;
        private String parseMode;
        private Boolean disableWebPagePreview;
        private List<MessageEntity> entities;

        InputTextMessageContentBuilder() {
        }

        @JsonProperty(value="message_text")
        public InputTextMessageContentBuilder messageText(@NonNull String messageText) {
            if (messageText == null) {
                throw new NullPointerException("messageText is marked non-null but is null");
            }
            this.messageText = messageText;
            return this;
        }

        @JsonProperty(value="parse_mode")
        public InputTextMessageContentBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        @JsonProperty(value="disable_web_page_preview")
        public InputTextMessageContentBuilder disableWebPagePreview(Boolean disableWebPagePreview) {
            this.disableWebPagePreview = disableWebPagePreview;
            return this;
        }

        @JsonProperty(value="entities")
        public InputTextMessageContentBuilder entities(List<MessageEntity> entities) {
            this.entities = entities;
            return this;
        }

        public InputTextMessageContent build() {
            return new InputTextMessageContent(this.messageText, this.parseMode, this.disableWebPagePreview, this.entities);
        }

        public String toString() {
            return "InputTextMessageContent.InputTextMessageContentBuilder(messageText=" + this.messageText + ", parseMode=" + this.parseMode + ", disableWebPagePreview=" + this.disableWebPagePreview + ", entities=" + this.entities + ")";
        }
    }
}

