/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InputLocationMessageContent
implements InputMessageContent {
    private static final String LATITUDE_FIELD = "latitude";
    private static final String LONGITUDE_FIELD = "longitude";
    private static final String LIVEPERIOD_FIELD = "live_period";
    private static final String HORIZONTALACCURACY_FIELD = "horizontal_accuracy";
    private static final String HEADING_FIELD = "heading";
    private static final String PROXIMITYALERTRADIUS_FIELD = "proximity_alert_radius";
    @JsonProperty(value="latitude")
    @NonNull
    private Double latitude;
    @JsonProperty(value="longitude")
    @NonNull
    private Double longitude;
    @JsonProperty(value="live_period")
    private Integer livePeriod;
    @JsonProperty(value="horizontal_accuracy")
    private Double horizontalAccuracy;
    @JsonProperty(value="heading")
    private Integer heading;
    @JsonProperty(value="proximity_alert_radius")
    private Integer proximityAlertRadius;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.latitude == null) {
            throw new TelegramApiValidationException("Latitude parameter can't be empty", this);
        }
        if (this.longitude == null) {
            throw new TelegramApiValidationException("Longitude parameter can't be empty", this);
        }
        if (this.livePeriod != null && (this.livePeriod < 60 || this.livePeriod > 86400)) {
            throw new TelegramApiValidationException("Live period parameter must be between 60 and 86400", this);
        }
        if (this.horizontalAccuracy != null && (this.horizontalAccuracy < 0.0 || this.horizontalAccuracy > 1500.0)) {
            throw new TelegramApiValidationException("Horizontal Accuracy parameter must be between 0 and 1500", this);
        }
        if (this.heading != null && (this.heading < 1 || this.heading > 360)) {
            throw new TelegramApiValidationException("Heading Accuracy parameter must be between 1 and 360", this);
        }
        if (this.proximityAlertRadius != null && (this.proximityAlertRadius < 1 || this.proximityAlertRadius > 100000)) {
            throw new TelegramApiValidationException("Approaching notification distance parameter must be between 1 and 100000", this);
        }
    }

    public static InputLocationMessageContentBuilder builder() {
        return new InputLocationMessageContentBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputLocationMessageContent)) {
            return false;
        }
        InputLocationMessageContent other = (InputLocationMessageContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Integer this$livePeriod = this.getLivePeriod();
        Integer other$livePeriod = other.getLivePeriod();
        if (this$livePeriod == null ? other$livePeriod != null : !((Object)this$livePeriod).equals(other$livePeriod)) {
            return false;
        }
        Double this$horizontalAccuracy = this.getHorizontalAccuracy();
        Double other$horizontalAccuracy = other.getHorizontalAccuracy();
        if (this$horizontalAccuracy == null ? other$horizontalAccuracy != null : !((Object)this$horizontalAccuracy).equals(other$horizontalAccuracy)) {
            return false;
        }
        Integer this$heading = this.getHeading();
        Integer other$heading = other.getHeading();
        if (this$heading == null ? other$heading != null : !((Object)this$heading).equals(other$heading)) {
            return false;
        }
        Integer this$proximityAlertRadius = this.getProximityAlertRadius();
        Integer other$proximityAlertRadius = other.getProximityAlertRadius();
        return !(this$proximityAlertRadius == null ? other$proximityAlertRadius != null : !((Object)this$proximityAlertRadius).equals(other$proximityAlertRadius));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputLocationMessageContent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Integer $livePeriod = this.getLivePeriod();
        result = result * 59 + ($livePeriod == null ? 43 : ((Object)$livePeriod).hashCode());
        Double $horizontalAccuracy = this.getHorizontalAccuracy();
        result = result * 59 + ($horizontalAccuracy == null ? 43 : ((Object)$horizontalAccuracy).hashCode());
        Integer $heading = this.getHeading();
        result = result * 59 + ($heading == null ? 43 : ((Object)$heading).hashCode());
        Integer $proximityAlertRadius = this.getProximityAlertRadius();
        result = result * 59 + ($proximityAlertRadius == null ? 43 : ((Object)$proximityAlertRadius).hashCode());
        return result;
    }

    @NonNull
    public Double getLatitude() {
        return this.latitude;
    }

    @NonNull
    public Double getLongitude() {
        return this.longitude;
    }

    public Integer getLivePeriod() {
        return this.livePeriod;
    }

    public Double getHorizontalAccuracy() {
        return this.horizontalAccuracy;
    }

    public Integer getHeading() {
        return this.heading;
    }

    public Integer getProximityAlertRadius() {
        return this.proximityAlertRadius;
    }

    @JsonProperty(value="latitude")
    public void setLatitude(@NonNull Double latitude) {
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        this.latitude = latitude;
    }

    @JsonProperty(value="longitude")
    public void setLongitude(@NonNull Double longitude) {
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.longitude = longitude;
    }

    @JsonProperty(value="live_period")
    public void setLivePeriod(Integer livePeriod) {
        this.livePeriod = livePeriod;
    }

    @JsonProperty(value="horizontal_accuracy")
    public void setHorizontalAccuracy(Double horizontalAccuracy) {
        this.horizontalAccuracy = horizontalAccuracy;
    }

    @JsonProperty(value="heading")
    public void setHeading(Integer heading) {
        this.heading = heading;
    }

    @JsonProperty(value="proximity_alert_radius")
    public void setProximityAlertRadius(Integer proximityAlertRadius) {
        this.proximityAlertRadius = proximityAlertRadius;
    }

    public String toString() {
        return "InputLocationMessageContent(latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", livePeriod=" + this.getLivePeriod() + ", horizontalAccuracy=" + this.getHorizontalAccuracy() + ", heading=" + this.getHeading() + ", proximityAlertRadius=" + this.getProximityAlertRadius() + ")";
    }

    public InputLocationMessageContent(@NonNull Double latitude, @NonNull Double longitude) {
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public InputLocationMessageContent() {
    }

    public InputLocationMessageContent(@NonNull Double latitude, @NonNull Double longitude, Integer livePeriod, Double horizontalAccuracy, Integer heading, Integer proximityAlertRadius) {
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.latitude = latitude;
        this.longitude = longitude;
        this.livePeriod = livePeriod;
        this.horizontalAccuracy = horizontalAccuracy;
        this.heading = heading;
        this.proximityAlertRadius = proximityAlertRadius;
    }

    public static class InputLocationMessageContentBuilder {
        private Double latitude;
        private Double longitude;
        private Integer livePeriod;
        private Double horizontalAccuracy;
        private Integer heading;
        private Integer proximityAlertRadius;

        InputLocationMessageContentBuilder() {
        }

        @JsonProperty(value="latitude")
        public InputLocationMessageContentBuilder latitude(@NonNull Double latitude) {
            if (latitude == null) {
                throw new NullPointerException("latitude is marked non-null but is null");
            }
            this.latitude = latitude;
            return this;
        }

        @JsonProperty(value="longitude")
        public InputLocationMessageContentBuilder longitude(@NonNull Double longitude) {
            if (longitude == null) {
                throw new NullPointerException("longitude is marked non-null but is null");
            }
            this.longitude = longitude;
            return this;
        }

        @JsonProperty(value="live_period")
        public InputLocationMessageContentBuilder livePeriod(Integer livePeriod) {
            this.livePeriod = livePeriod;
            return this;
        }

        @JsonProperty(value="horizontal_accuracy")
        public InputLocationMessageContentBuilder horizontalAccuracy(Double horizontalAccuracy) {
            this.horizontalAccuracy = horizontalAccuracy;
            return this;
        }

        @JsonProperty(value="heading")
        public InputLocationMessageContentBuilder heading(Integer heading) {
            this.heading = heading;
            return this;
        }

        @JsonProperty(value="proximity_alert_radius")
        public InputLocationMessageContentBuilder proximityAlertRadius(Integer proximityAlertRadius) {
            this.proximityAlertRadius = proximityAlertRadius;
            return this;
        }

        public InputLocationMessageContent build() {
            return new InputLocationMessageContent(this.latitude, this.longitude, this.livePeriod, this.horizontalAccuracy, this.heading, this.proximityAlertRadius);
        }

        public String toString() {
            return "InputLocationMessageContent.InputLocationMessageContentBuilder(latitude=" + this.latitude + ", longitude=" + this.longitude + ", livePeriod=" + this.livePeriod + ", horizontalAccuracy=" + this.horizontalAccuracy + ", heading=" + this.heading + ", proximityAlertRadius=" + this.proximityAlertRadius + ")";
        }
    }
}

