/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.forum;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class EditForumTopic
extends BotApiMethodBoolean {
    public static final String PATH = "editForumTopic";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGETHREADID_FIELD = "message_thread_id";
    private static final String NAME_FIELD = "name";
    private static final String ICONCUSTOMEMOJIID_FIELD = "icon_custom_emoji_id";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_thread_id")
    @NonNull
    private Integer messageThreadId;
    @JsonProperty(value="name")
    @NonNull
    private String name;
    @JsonProperty(value="icon_custom_emoji_id")
    @NonNull
    private String iconCustomEmojiId;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.name.isEmpty() || this.name.length() > 128) {
            throw new TelegramApiValidationException("Name must be between 1 and 128 characters", this);
        }
        if (this.messageThreadId <= 0) {
            throw new TelegramApiValidationException("Message Thread Id can't be empty", this);
        }
        if (this.iconCustomEmojiId.isEmpty()) {
            throw new TelegramApiValidationException("Icon Custom Emoji Id can't be empty", this);
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    public static EditForumTopicBuilder builder() {
        return new EditForumTopicBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditForumTopic)) {
            return false;
        }
        EditForumTopic other = (EditForumTopic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$iconCustomEmojiId = this.getIconCustomEmojiId();
        String other$iconCustomEmojiId = other.getIconCustomEmojiId();
        return !(this$iconCustomEmojiId == null ? other$iconCustomEmojiId != null : !this$iconCustomEmojiId.equals(other$iconCustomEmojiId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EditForumTopic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $iconCustomEmojiId = this.getIconCustomEmojiId();
        result = result * 59 + ($iconCustomEmojiId == null ? 43 : $iconCustomEmojiId.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getIconCustomEmojiId() {
        return this.iconCustomEmojiId;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_thread_id")
    public void setMessageThreadId(@NonNull Integer messageThreadId) {
        if (messageThreadId == null) {
            throw new NullPointerException("messageThreadId is marked non-null but is null");
        }
        this.messageThreadId = messageThreadId;
    }

    @JsonProperty(value="name")
    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @JsonProperty(value="icon_custom_emoji_id")
    public void setIconCustomEmojiId(@NonNull String iconCustomEmojiId) {
        if (iconCustomEmojiId == null) {
            throw new NullPointerException("iconCustomEmojiId is marked non-null but is null");
        }
        this.iconCustomEmojiId = iconCustomEmojiId;
    }

    public String toString() {
        return "EditForumTopic(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", name=" + this.getName() + ", iconCustomEmojiId=" + this.getIconCustomEmojiId() + ")";
    }

    public EditForumTopic() {
    }

    public EditForumTopic(@NonNull String chatId, @NonNull Integer messageThreadId, @NonNull String name, @NonNull String iconCustomEmojiId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (messageThreadId == null) {
            throw new NullPointerException("messageThreadId is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (iconCustomEmojiId == null) {
            throw new NullPointerException("iconCustomEmojiId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.name = name;
        this.iconCustomEmojiId = iconCustomEmojiId;
    }

    public static class EditForumTopicBuilder {
        private String chatId;
        private Integer messageThreadId;
        private String name;
        private String iconCustomEmojiId;

        public EditForumTopicBuilder chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        EditForumTopicBuilder() {
        }

        @JsonProperty(value="chat_id")
        public EditForumTopicBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="message_thread_id")
        public EditForumTopicBuilder messageThreadId(@NonNull Integer messageThreadId) {
            if (messageThreadId == null) {
                throw new NullPointerException("messageThreadId is marked non-null but is null");
            }
            this.messageThreadId = messageThreadId;
            return this;
        }

        @JsonProperty(value="name")
        public EditForumTopicBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @JsonProperty(value="icon_custom_emoji_id")
        public EditForumTopicBuilder iconCustomEmojiId(@NonNull String iconCustomEmojiId) {
            if (iconCustomEmojiId == null) {
                throw new NullPointerException("iconCustomEmojiId is marked non-null but is null");
            }
            this.iconCustomEmojiId = iconCustomEmojiId;
            return this;
        }

        public EditForumTopic build() {
            return new EditForumTopic(this.chatId, this.messageThreadId, this.name, this.iconCustomEmojiId);
        }

        public String toString() {
            return "EditForumTopic.EditForumTopicBuilder(chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", name=" + this.name + ", iconCustomEmojiId=" + this.iconCustomEmojiId + ")";
        }
    }
}

