/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao.process;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.Pageable;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.dao.LastModifyDAO;
import ru.bgcrm.dao.process.StatusDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.model.process.Status;
import ru.bgcrm.model.process.TypeProperties;
import ru.bgcrm.util.Utils;

public class ProcessTypeDAO
extends CommonDAO {
    private static final String SHORT_COLUMN_LIST = "id, title, parent_id, child_count, use_parent_props";

    public ProcessTypeDAO(Connection con) {
        super(con);
    }

    public void searchProcessType(Pageable<ProcessType> result, int parentId, String filterLike) throws Exception {
        if (result != null) {
            Page page = result.getPage();
            List<ProcessType> list = result.getList();
            try (PreparedQuery pq = new PreparedQuery(this.con);){
                pq.addQuery("SELECT SQL_CALC_FOUND_ROWS ");
                pq.addQuery(SHORT_COLUMN_LIST);
                pq.addQuery(" FROM ");
                pq.addQuery(" process_type ");
                pq.addQuery(" WHERE ");
                pq.addQuery("1>0");
                if (parentId >= 0) {
                    pq.addQuery(" AND parent_id=?");
                    pq.addInt(parentId);
                }
                if (Utils.notBlankString(filterLike)) {
                    pq.addQuery(" AND (id LIKE ? OR title LIKE ? OR config LIKE ?)");
                    pq.addString(filterLike);
                    pq.addString(filterLike);
                    pq.addString(filterLike);
                }
                pq.addQuery(" ORDER BY ");
                pq.addQuery("title");
                pq.addQuery(page.getLimitSql());
                ResultSet rs = pq.executeQuery();
                while (rs.next()) {
                    list.add(this.getTypeFromRs(rs, false));
                }
                page.setRecordCount(pq.getPrepared());
            }
        }
    }

    public ProcessType getProcessType(int id) throws Exception {
        ProcessType result = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        ps = this.con.prepareStatement("SELECT * FROM  process_type  WHERE id=?");
        ps.setInt(1, id);
        rs = ps.executeQuery();
        while (rs.next()) {
            result = this.getTypeFromRs(rs, true);
        }
        ps.close();
        if (result != null && (Integer)result.getId() > 0) {
            ps = this.con.prepareStatement("SELECT * FROM  process_type  WHERE parent_id=?");
            ps.setInt(1, (Integer)result.getId());
            rs = ps.executeQuery();
            while (rs.next()) {
                result.addChild(this.getTypeFromRs(rs, true));
            }
            ps.close();
        }
        return result;
    }

    public List<ProcessType> getTypeChildren(int parentId, Set<Integer> excludeIds) throws Exception {
        ArrayList<ProcessType> result = new ArrayList<ProcessType>();
        Object query = "SELECT * FROM  process_type  WHERE parent_id=?";
        if (excludeIds != null) {
            query = (String)query + " AND id NOT IN (" + Utils.toString(excludeIds) + ")";
        }
        query = (String)query + " ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement((String)query);){
            ps.setInt(1, parentId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getTypeFromRs(rs, false));
            }
        }
        return result;
    }

    public List<ProcessType> getFullProcessTypeList() throws SQLException {
        ArrayList<ProcessType> result = new ArrayList<ProcessType>();
        HashMap<Integer, ProcessType> typeMap = new HashMap<Integer, ProcessType>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM  process_type  ORDER BY title");){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProcessType type = this.getTypeFromRs(rs, true);
                typeMap.put((Integer)type.getId(), type);
                result.add(type);
            }
        }
        for (ProcessType type : result) {
            if (!type.isUseParentProperties()) continue;
            this.setParentTypeProperties(type, typeMap, (Integer)type.getParentId());
        }
        for (ProcessType type : result) {
            if ((Integer)type.getParentId() <= 0) continue;
            ProcessType parentType = (ProcessType)typeMap.get(type.getParentId());
            parentType.addChild(type);
        }
        return result;
    }

    private void setParentTypeProperties(ProcessType type, Map<Integer, ProcessType> typeMap, int parentId) {
        ProcessType parent = typeMap.get(parentId);
        if (parent != null) {
            if (parent.isUseParentProperties()) {
                this.setParentTypeProperties(type, typeMap, (Integer)parent.getParentId());
            } else {
                type.setProperties(parent.getProperties());
            }
        }
    }

    @Deprecated
    public List<Status> getSortedProcessTypeStatusList(ProcessType type, List<Integer> sortingId) {
        ArrayList<Status> result = new ArrayList<Status>();
        List<Status> statusList = this.getProcessTypeStatusList(type);
        for (Integer id : sortingId) {
            for (Status status : statusList) {
                if (status.getId() != id) continue;
                result.add(status);
            }
        }
        return result;
    }

    @Deprecated
    public List<Status> getProcessTypeStatusList(ProcessType type) {
        try {
            ArrayList<Status> result = new ArrayList<Status>();
            ResultSet rs = null;
            PreparedStatement ps = null;
            String query = null;
            query = "SELECT status.* FROM  process_status_title  AS status WHERE status.id IN ( " + Utils.toString(type.getProperties().getStatusIds(), "-1", ",") + ") ORDER BY pos";
            ps = this.con.prepareStatement(query);
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(StatusDAO.getStatusFromRs(rs));
            }
            ps.close();
            return result;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void updateProcessType(ProcessType processType, int userId) throws Exception {
        this.setChildCount((Integer)processType.getId(), -1);
        int index = 1;
        PreparedStatement ps = null;
        if ((Integer)processType.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO  process_type  SET title=?, parent_id=?, use_parent_props=?, data=?, config=?, last_modify_user_id=?, last_modify_dt=NOW()", 1);
            ps.setString(index++, processType.getTitle());
            ps.setInt(index++, (Integer)processType.getParentId());
            ps.setBoolean(index++, processType.isUseParentProperties());
            ps.setString(index++, "");
            ps.setString(index++, "");
            ps.setInt(index++, userId);
            ps.executeUpdate();
            processType.setId(this.lastInsertId(ps));
        } else {
            ps = this.con.prepareStatement("UPDATE  process_type  SET title=?, parent_id=?, use_parent_props=? WHERE id=?");
            ps.setString(index++, processType.getTitle());
            ps.setInt(index++, (Integer)processType.getParentId());
            ps.setBoolean(index++, processType.isUseParentProperties());
            ps.setInt(index++, (Integer)processType.getId());
            ps.executeUpdate();
        }
        ps.close();
        this.setChildCount((Integer)processType.getId(), 0);
    }

    public void updateTypeProperties(ProcessType type) {
        try {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ");
            query.append(" process_type ");
            query.append(" SET ");
            query.append("data=?, config=?, last_modify_user_id=?, last_modify_dt=?");
            query.append(" WHERE ");
            query.append("id=?");
            TypeProperties properties = type.getProperties();
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setString(1, properties.serializeToData());
            ps.setString(2, properties.getConfig());
            LastModifyDAO.setLastModifyFields(ps, 3, 4, type.getProperties().getLastModify());
            ps.setInt(5, (Integer)type.getId());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void copyTypeProperties(int fromTypeId, int toTypeId) throws Exception {
        ProcessType type = this.getProcessType(fromTypeId);
        type.setId(toTypeId);
        this.updateTypeProperties(type);
    }

    public boolean checkProcessTypeForDelete(int id) throws Exception {
        this.setChildCount(id, 0);
        ProcessType processType = this.getProcessType(id);
        if (processType != null) {
            return processType.getChildCount() == 0;
        }
        return false;
    }

    public boolean deleteProcessType(int id) throws Exception {
        boolean result = false;
        this.setChildCount(id, -1);
        if (id > 0) {
            int index = 1;
            PreparedStatement ps = null;
            ps = this.con.prepareStatement("DELETE FROM  process_type  WHERE id=?");
            ps.setInt(index++, id);
            result = ps.executeUpdate() > 0;
            ps.close();
        }
        return result;
    }

    private ProcessType getTypeFromRs(ResultSet rs, boolean loadFull) throws SQLException {
        ProcessType type = new ProcessType();
        type.setId(rs.getInt("id"));
        type.setTitle(rs.getString("title"));
        type.setParentId(rs.getInt("parent_id"));
        type.setUseParentProperties(rs.getBoolean("use_parent_props"));
        if (loadFull) {
            type.setProperties(new TypeProperties(rs.getString("data"), rs.getString("config"), LastModifyDAO.getLastModify(rs)));
        }
        return type;
    }

    private void setChildCount(int chilsId, int countCorrect) {
        try {
            ResultSet rs = null;
            PreparedStatement ps = null;
            ps = this.con.prepareStatement("select count(*), t1.parent_id from  process_type  as t1 join  process_type  as t2 where t2.id = ? AND t1.parent_id = t2.parent_id");
            ps.setInt(1, chilsId);
            rs = ps.executeQuery();
            int count = 0;
            int parentId = 0;
            if (rs.next()) {
                count = rs.getInt(1);
                parentId = rs.getInt(2);
            }
            ps.close();
            PreparedStatement psUpdate = this.con.prepareStatement("UPDATE  process_type  SET child_count=? WHERE id=? ");
            int index = 1;
            psUpdate.setInt(index++, count += countCorrect);
            psUpdate.setInt(index++, parentId);
            psUpdate.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public boolean checkType(int id, int parentId, String title) throws Exception {
        boolean result = false;
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append("COUNT(*)");
        query.append(" FROM ");
        query.append(" process_type ");
        query.append(" WHERE ");
        query.append("id !=? AND parent_id=? AND title=?");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        int index = 1;
        ps.setInt(index++, id);
        ps.setInt(index++, parentId);
        ps.setString(index++, title);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1) == 0;
        }
        ps.close();
        return result;
    }
}

