/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao.message;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.bgerp.app.exception.BGException;
import org.bgerp.dao.FileDataDAO;
import org.bgerp.model.Pageable;
import org.bgerp.model.file.FileData;
import org.bgerp.model.msg.Message;
import org.bgerp.model.process.config.IsolationConfig;
import org.bgerp.util.TimeConvert;
import org.bgerp.util.sql.LikePattern;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.user.User;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.SQLUtils;

public class MessageDAO
extends CommonDAO {
    private final DynActionForm form;

    public MessageDAO(Connection con) {
        super(con);
        this.form = null;
    }

    public MessageDAO(Connection con, DynActionForm form) {
        super(con);
        this.form = form;
    }

    public Message getMessageById(int id) throws SQLException {
        Message result = null;
        String query = "SELECT m.*, p.* FROM  message  AS m LEFT JOIN  process  AS p ON m.process_id=p.id WHERE m.id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = MessageDAO.getMessageFromRs(rs, "m.");
            if (rs.getInt("p.id") > 0) {
                result.setProcess(ProcessDAO.getProcessFromRs(rs, "p."));
            }
        }
        ps.close();
        return result;
    }

    public Message getMessageBySystemId(int typeId, String systemId) throws SQLException {
        Message result = null;
        String query = "SELECT m.*, p.* FROM  message  AS m LEFT JOIN  process  AS p ON m.process_id=p.id WHERE m.type_id=? AND m.system_id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, typeId);
        ps.setString(2, systemId);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = MessageDAO.getMessageFromRs(rs, "m.");
            if (rs.getInt("p.id") > 0) {
                result.setProcess(ProcessDAO.getProcessFromRs(rs, "p."));
            }
        }
        ps.close();
        return result;
    }

    public void updateMessage(Message message) throws SQLException {
        PreparedStatement ps = null;
        if (message.getId() <= 0) {
            query = "INSERT INTO  message (system_id, type_id, direction, `from`, `to`, subject, text, user_id, process_id, from_dt, to_dt, attach_data) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            ps = this.con.prepareStatement(query, 1);
        } else {
            query = "UPDATE  message SET system_id=?, type_id=?, direction=?, `from`=?, `to`=?, subject=?, text=?, user_id=?, process_id=?, from_dt=?, to_dt=?, attach_data=? WHERE id=?";
            ps = this.con.prepareStatement(query);
        }
        int index = 1;
        ps.setString(index++, message.getSystemId());
        ps.setInt(index++, message.getTypeId());
        ps.setInt(index++, message.getDirection());
        ps.setString(index++, message.getFrom());
        ps.setString(index++, message.getTo());
        ps.setString(index++, message.getSubject());
        ps.setString(index++, message.getText());
        ps.setInt(index++, message.getUserId());
        ps.setInt(index++, message.getProcessId());
        ps.setTimestamp(index++, TimeConvert.toTimestamp(message.getFromTime()));
        ps.setTimestamp(index++, TimeConvert.toTimestamp(message.getToTime()));
        ps.setString(index++, FileData.serialize(message.getAttachList()));
        if (message.getId() > 0) {
            ps.setInt(index++, message.getId());
        }
        ps.executeUpdate();
        if (message.getId() <= 0) {
            message.setId(SQLUtils.lastInsertId(ps));
        }
        ps.close();
        this.updateProcessLastMessageTime(message);
    }

    public void updateMessageProcess(Message message) throws SQLException {
        String query = "UPDATE  message SET user_id=?, to_dt=?, process_id=? WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        int index = 1;
        ps.setInt(index++, message.getUserId());
        ps.setTimestamp(index++, TimeConvert.toTimestamp(message.getToTime()));
        ps.setInt(index++, message.getProcessId());
        ps.setInt(index++, message.getId());
        ps.executeUpdate();
        ps.close();
        this.updateProcessLastMessageTime(message);
    }

    public void updateMessageTags(int messageId, Set<Integer> tagIds, boolean positiveOnly) throws SQLException {
        Object query = "DELETE FROM  message_tag  WHERE message_id=?";
        if (positiveOnly) {
            query = (String)query + " AND tag_id>0";
        }
        try (PreparedStatement ps = this.con.prepareStatement((String)query);){
            ps.setInt(1, messageId);
            ps.executeUpdate();
        }
        query = "INSERT INTO  message_tag (message_id, tag_id) VALUES (?,?)";
        ps = this.con.prepareStatement((String)query);
        try {
            ps.setInt(1, messageId);
            for (int tagId : tagIds) {
                ps.setInt(2, tagId);
                ps.executeUpdate();
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void toggleMessageTags(int messageId, Set<Integer> tagIds, boolean add) throws SQLException {
        if (add) {
            String query = "INSERT INTO  message_tag (message_id, tag_id) VALUES (?,?)";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setInt(1, messageId);
                for (int tagId : tagIds) {
                    ps.setInt(2, tagId);
                    ps.executeUpdate();
                }
            }
        }
        if (!tagIds.isEmpty()) {
            String query = "DELETE FROM  message_tag  WHERE message_id=? AND tag_id IN (" + Utils.toString(tagIds) + ")";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setInt(1, messageId);
                ps.executeUpdate();
            }
        }
    }

    public Set<Integer> getMessageTags(int messageId) throws SQLException {
        return this.getIds(" message_tag ", "message_id", "tag_id", messageId);
    }

    public void deleteMessage(int id) throws Exception {
        Message message = null;
        if (id > 0) {
            message = this.getMessageById(id);
        }
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM  message  WHERE id=?");){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        ps = this.con.prepareStatement("DELETE FROM  message_tag  WHERE message_id=?");
        try {
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        if (message != null) {
            this.updateProcessLastMessageTime(message);
            List<FileData> attaches = message.getAttachList();
            if (attaches != null) {
                FileDataDAO dao = new FileDataDAO(this.con);
                for (FileData file : attaches) {
                    dao.delete(file);
                }
            }
        }
    }

    public void deleteProcessMessages(int processId) throws SQLException {
        String query = "DELETE message, process_message_state, message_tag FROM  message AS message INNER JOIN  process_message_state AS process_message_state ON message.process_id=process_message_state.process_id INNER JOIN  message_tag AS message_tag ON message.id=message_tag.message_id WHERE message.process_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, processId);
            ps.executeUpdate();
        }
    }

    private void updateProcessLastMessageTime(Message message) throws SQLException {
        if (message.getProcessId() > 0) {
            Timestamp lastIncomingTime = null;
            int countIn = 0;
            int countInUnread = 0;
            int lastInId = 0;
            int countOut = 0;
            int lastOutId = 0;
            String query = "SELECT CAST(MAX(IF(direction=1,from_dt,NULL)) AS DATETIME), COUNT(IF(direction=1,1,0)), SUM(IF(direction=1 AND ISNULL(to_dt), 1, 0)), MAX(IF(direction=1,id,0)), COUNT(IF(direction=2,1,NULL)), MAX(IF(direction=2,id,0)) FROM  message WHERE process_id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setInt(1, message.getProcessId());
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    lastIncomingTime = rs.getTimestamp(1);
                    countIn = rs.getInt(2);
                    countInUnread = rs.getInt(3);
                    lastInId = rs.getInt(4);
                    countOut = rs.getInt(5);
                    lastOutId = rs.getInt(6);
                }
            }
            int pos = 0;
            query = "INSERT INTO  process_message_state  SET process_id=?, in_last_dt=?, in_count=?, in_unread_count=?, in_last_id=?, out_count=?, out_last_id=?  ON DUPLICATE KEY UPDATE in_last_dt=?, in_count=?, in_unread_count=?, in_last_id=?, out_count=?, out_last_id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setInt(++pos, message.getProcessId());
                for (int i = 0; i < 2; ++i) {
                    ps.setTimestamp(++pos, lastIncomingTime);
                    ps.setInt(++pos, countIn);
                    ps.setInt(++pos, countInUnread);
                    ps.setInt(++pos, lastInId);
                    ps.setInt(++pos, countOut);
                    ps.setInt(++pos, lastOutId);
                }
                ps.executeUpdate();
            }
        }
    }

    public List<Message> getUnsendMessageList(int type, int maxCount) {
        ArrayList<Message> result = new ArrayList<Message>();
        try {
            String query = "SELECT * FROM  message WHERE type_id=? AND direction=? AND to_dt IS NULL LIMIT ?";
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, type);
            ps.setInt(2, 2);
            ps.setInt(3, maxCount);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getMessageFromRs(rs));
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    @Deprecated
    public void searchMessageList(Pageable<Message> searchResult, Integer processId, Integer typeId, Integer direction, Boolean processed, Boolean withAttach, Date dateFrom, Date dateTo, String from) {
        this.searchMessageList(searchResult, processId, typeId, direction, processed, withAttach, dateFrom, dateTo, from, true);
    }

    @Deprecated
    public void searchMessageList(Pageable<Message> searchResult, Integer processId, Integer typeId, Integer direction, Boolean processed, Boolean withAttach, Date dateFrom, Date dateTo, String from, boolean reverseOrder) {
        this.searchMessageList(searchResult, processId, typeId, direction, processed, withAttach, dateFrom, dateTo, from, true, null);
    }

    @Deprecated
    public void searchMessageList(Pageable<Message> searchResult, Integer processId, Integer typeId, Integer direction, Boolean processed, Boolean withAttach, Date dateFrom, Date dateTo, String from, boolean reverseOrder, Set<Integer> tagIds) {
        this.searchMessageList(searchResult, processId != null ? Collections.singleton(processId) : null, typeId != null ? Collections.singleton(typeId) : null, direction, processed, withAttach, dateFrom, dateTo, from, true, tagIds);
    }

    @Deprecated
    public void searchMessageList(Pageable<Message> searchResult, Collection<Integer> processIds, Integer typeId, Integer direction, Boolean processed, Boolean withAttach, Date dateFrom, Date dateTo, String from, boolean reverseOrder, Set<Integer> tagIds) {
        this.searchMessageList(searchResult, processIds, typeId != null ? Collections.singleton(typeId) : null, direction, processed, withAttach, dateFrom, dateTo, from, true, tagIds);
    }

    @Deprecated
    public void searchMessageList(Pageable<Message> searchResult, Collection<Integer> processIds, Set<Integer> typeIds, Integer direction, Boolean processed, Boolean withAttach, Date dateFrom, Date dateTo, String from, boolean reverseOrder, Set<Integer> tagIds) {
        try {
            Page page = searchResult.getPage();
            PreparedQuery ps = new PreparedQuery(this.con);
            ps.addQuery("SELECT SQL_CALC_FOUND_ROWS  m.*, p.* FROM  message  AS m LEFT JOIN  process  AS p ON m.process_id=p.id ");
            if (CollectionUtils.isNotEmpty(tagIds)) {
                ps.addQuery(" INNER JOIN  message_tag  AS mt ON m.id=mt.message_id AND mt.tag_id IN (" + Utils.toString(tagIds) + ")");
            }
            ps.addQuery("WHERE 1>0 ");
            if (processIds != null) {
                ps.addQuery(" AND m.process_id IN (");
                ps.addQuery(Utils.toString(processIds));
                ps.addQuery(")");
            }
            if (CollectionUtils.isNotEmpty(typeIds)) {
                ps.addQuery(" AND m.type_id IN (");
                ps.addQuery(Utils.toString(typeIds));
                ps.addQuery(")");
            }
            if (direction != null) {
                ps.addQuery(" AND m.direction=?");
                ps.addInt(direction);
            }
            if (processed != null) {
                if (processed.booleanValue()) {
                    ps.addQuery(" AND processed");
                } else {
                    ps.addQuery(" AND NOT(processed)");
                }
            }
            if (withAttach != null) {
                if (withAttach.booleanValue()) {
                    ps.addQuery(" AND attach_data");
                } else {
                    ps.addQuery(" AND NOT(attach_data)");
                }
            }
            if (dateFrom != null) {
                ps.addQuery(" AND ?< m.from_dt");
                ps.addDate(dateFrom);
            }
            if (dateTo != null) {
                ps.addQuery(" AND m.from_dt <?");
                ps.addDate(TimeUtils.getNextDay(dateTo));
            }
            if (Utils.notBlankString(from)) {
                ps.addQuery(" AND m.from LIKE ?");
                ps.addString(from);
            }
            ps.addQuery(" ORDER BY m.from_dt ");
            if (reverseOrder) {
                ps.addQuery(" DESC");
            }
            ps.addQuery(page.getLimitSql());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Message message = MessageDAO.getMessageFromRs(rs, "m.");
                searchResult.getList().add(message);
                if (rs.getInt("p.id") <= 0) continue;
                message.setProcess(ProcessDAO.getProcessFromRs(rs, "p."));
            }
            page.setRecordCount(ps.getPrepared());
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public List<Message> getProcessMessageList(int processId, int beforeMessageId) throws Exception {
        ArrayList<Message> list = new ArrayList<Message>();
        PreparedQuery pq = new PreparedQuery(this.con, "SELECT SQL_CALC_FOUND_ROWS  * FROM  message WHERE process_id=?");
        pq.addInt(processId);
        if (beforeMessageId > 0) {
            pq.addQuery(" AND id<?");
            pq.addInt(beforeMessageId);
        }
        pq.addQuery(" ORDER BY id");
        ResultSet rs = pq.executeQuery();
        while (rs.next()) {
            list.add(this.getMessageFromRs(rs));
        }
        pq.close();
        return list;
    }

    public Map<Integer, Set<Integer>> getProcessMessageTagMap(int processId) throws SQLException {
        return this.getProcessMessageTagMap(Collections.singleton(processId));
    }

    public Map<Integer, Set<Integer>> getProcessMessageTagMap(Collection<Integer> processIds) throws SQLException {
        HashMap<Integer, Set<Integer>> result = new HashMap<Integer, Set<Integer>>();
        String query = "SELECT m.id, m.to_dt, m.attach_data, mt.tag_id FROM  message AS m LEFT JOIN  message_tag  AS mt ON m.id=mt.message_id  WHERE m.process_id IN (" + Utils.toString(processIds) + ")";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Set messageTags = null;
                int messageId = rs.getInt("m.id");
                if (!Utils.isBlankString(rs.getString("m.attach_data"))) {
                    messageTags = result.computeIfAbsent(messageId, id -> new HashSet());
                    messageTags.add(-1);
                }
                if (rs.getTimestamp("m.to_dt") == null) {
                    messageTags = result.computeIfAbsent(messageId, id -> new HashSet());
                    messageTags.add(-5);
                }
                int tagId = rs.getInt("mt.tag_id");
                if (messageTags == null) {
                    messageTags = result.computeIfAbsent(messageId, id -> new HashSet());
                }
                messageTags.add(tagId);
            }
        }
        return result;
    }

    public List<Message> getProcessMessageList(Set<Integer> processIds, String text) throws Exception {
        ArrayList<Message> result = new ArrayList<Message>();
        if (processIds.isEmpty() || Utils.isBlankString(text)) {
            return result;
        }
        StringBuilder query = new StringBuilder(200);
        query.append("SELECT message.*, p.description  FROM  message  AS message ");
        query.append(MessageDAO.getIsolationJoin(this.form));
        query.append(" LEFT JOIN  process AS p ON message.process_id=p.id");
        query.append(" WHERE message.process_id IN (");
        query.append(Utils.toString(processIds));
        query.append(") AND message.text LIKE ?");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setString(1, LikePattern.SUB.get(text));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Message m = MessageDAO.getMessageFromRs(rs, "message.");
                Process p = new Process(m.getProcessId());
                p.setDescription(rs.getString("p.description"));
                m.setProcess(p);
                result.add(m);
            }
        }
        return result;
    }

    public static String getIsolationJoin(DynActionForm form) {
        if (form == null) {
            return "";
        }
        User user = form.getUser();
        IsolationConfig isolation = user.getConfigMap().getConfig(IsolationConfig.class);
        if (isolation.getIsolationProcess() != null) {
            return " INNER JOIN  process  AS process ON message.process_id=process.id " + ProcessDAO.getIsolationJoin(form, "process");
        }
        return "";
    }

    private Message getMessageFromRs(ResultSet rs) throws SQLException {
        return MessageDAO.getMessageFromRs(rs, "");
    }

    public static Message getMessageFromRs(ResultSet rs, String prefix) throws SQLException {
        Message result = new Message();
        result.setId(rs.getInt(prefix + "id"));
        result.setSystemId(rs.getString(prefix + "system_id"));
        result.setTypeId(rs.getInt(prefix + "type_id"));
        result.setProcessId(rs.getInt(prefix + "process_id"));
        result.setDirection(rs.getInt(prefix + "direction"));
        result.setFrom(rs.getString(prefix + "from"));
        result.setTo(rs.getString(prefix + "to"));
        result.setSubject(rs.getString(prefix + "subject"));
        result.setText(rs.getString(prefix + "text"));
        result.setFromTime(rs.getTimestamp(prefix + "from_dt"));
        result.setToTime(rs.getTimestamp(prefix + "to_dt"));
        result.setUserId(rs.getInt(prefix + "user_id"));
        result.setSystemId(rs.getString(prefix + "system_id"));
        for (FileData data : FileData.parse(rs.getString(prefix + "attach_data"))) {
            result.addAttach(data);
        }
        return result;
    }
}

