/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.util.sql;

import ru.bgcrm.util.Utils;

public enum LikePattern {
    SUB{

        @Override
        public String get(String substr) {
            if (Utils.isBlankString(substr)) {
                return substr;
            }
            StringBuilder result = new StringBuilder(substr.length() + 2);
            if (!substr.startsWith(LikePattern.ANY)) {
                result.append(LikePattern.ANY);
            }
            result.append(substr);
            if (!substr.endsWith(LikePattern.ANY)) {
                result.append(LikePattern.ANY);
            }
            return result.toString();
        }
    }
    ,
    END{

        @Override
        public String get(String substr) {
            if (Utils.isBlankString(substr)) {
                return substr;
            }
            StringBuilder result = new StringBuilder(substr.length() + 1);
            if (!substr.startsWith(LikePattern.ANY)) {
                result.append(LikePattern.ANY);
            }
            result.append(substr);
            return result.toString();
        }
    }
    ,
    START{

        @Override
        public String get(String substr) {
            if (Utils.isBlankString(substr)) {
                return substr;
            }
            StringBuilder result = new StringBuilder(substr.length() + 1);
            result.append(substr);
            if (!substr.endsWith(LikePattern.ANY)) {
                result.append(LikePattern.ANY);
            }
            return result.toString();
        }
    }
    ,
    EQ{

        @Override
        public String get(String substr) {
            return substr;
        }
    };

    private static final String ANY = "%";

    public static LikePattern of(String type) {
        return switch (type) {
            case "sub" -> SUB;
            case "end" -> END;
            case "start" -> START;
            case "eq" -> EQ;
            default -> throw new IllegalArgumentException("Incorrect type: " + type);
        };
    }

    public abstract String get(String var1);
}

