/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.util.mail;

import com.google.common.annotations.VisibleForTesting;
import jakarta.mail.Message;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.exception.BGMessageExceptionWithoutL10n;
import org.bgerp.util.Dynamic;
import org.bgerp.util.Log;
import ru.bgcrm.util.Utils;

@Dynamic
public class Addresses
extends HashMap<Message.RecipientType, List<InternetAddress>> {
    private static final Log log = Log.getLog();
    private static final Message.RecipientType[] RECIPIENT_TYPES = new Message.RecipientType[]{Message.RecipientType.TO, Message.RecipientType.CC, Message.RecipientType.BCC};
    private static final String RECIPIENT_TYPE_PREFIX_CC = Message.RecipientType.CC.toString().toUpperCase();
    private static final String RECIPIENT_TYPE_PREFIX_BCC = Message.RecipientType.BCC.toString().toUpperCase();

    public Addresses() {
    }

    @Dynamic
    public Addresses(String addresses) {
        try {
            this.parse(null, addresses, true);
        }
        catch (BGMessageException e) {
            throw new IllegalStateException("The exception must not be thrown here", e);
        }
    }

    @VisibleForTesting
    Addresses(Map<Message.RecipientType, List<InternetAddress>> addresses) {
        super(addresses);
    }

    public static Addresses parse(String lang, String addresses) throws BGMessageException {
        return new Addresses().parse(lang, addresses, false);
    }

    public static Addresses parseSafe(String addresses) {
        try {
            return new Addresses().parse(null, addresses, true);
        }
        catch (BGMessageException e) {
            throw new IllegalStateException("The exception must not be thrown here", e);
        }
    }

    private Addresses parse(String lang, String addresses, boolean silent) throws BGMessageException {
        if (Utils.isEmptyString(addresses)) {
            return this;
        }
        Message.RecipientType type = Message.RecipientType.TO;
        for (String token : addresses.split("\\s*[,;]\\s*")) {
            int pos = token.indexOf(58);
            String prefix = null;
            if (pos > 0) {
                prefix = token.substring(0, pos);
                token = token.substring(pos + 1);
                if (prefix.equalsIgnoreCase(RECIPIENT_TYPE_PREFIX_CC)) {
                    type = Message.RecipientType.CC;
                } else if (prefix.equalsIgnoreCase(RECIPIENT_TYPE_PREFIX_BCC)) {
                    type = Message.RecipientType.BCC;
                } else {
                    if (silent) {
                        log.debug("Incorrect prefix: {}", prefix);
                        continue;
                    }
                    throw new BGMessageExceptionWithoutL10n("Incorrect prefix: {}", prefix);
                }
            }
            try {
                InternetAddress addr = InternetAddress.parse((String)token)[0];
                addr.validate();
                this.computeIfAbsent(type, unused -> new ArrayList()).add(addr);
            }
            catch (AddressException e) {
                if (silent) {
                    log.debug("Incorrect email: {}", token);
                    continue;
                }
                throw new BGMessageExceptionWithoutL10n("Incorrect email: {}", token);
            }
        }
        return this;
    }

    public Addresses addTo(String value) {
        try {
            this.computeIfAbsent(Message.RecipientType.TO, unused -> new ArrayList(1)).add(new InternetAddress(value));
        }
        catch (AddressException e) {
            throw new IllegalStateException("The exception must not be thrown", e);
        }
        return this;
    }

    public Addresses exclude(String value) {
        try {
            InternetAddress address = InternetAddress.parse((String)value)[0];
            this.values().forEach((? super T values) -> values.remove(address));
        }
        catch (AddressException e) {
            throw new IllegalStateException("The exception must not be thrown", e);
        }
        return this;
    }

    @Dynamic
    public String serializeTo() {
        return this.serialize(Message.RecipientType.TO);
    }

    @Dynamic
    public String serializeCc() {
        return this.serialize(Message.RecipientType.CC);
    }

    @Dynamic
    public String serializeBcc() {
        return this.serialize(Message.RecipientType.BCC);
    }

    private String serialize(Message.RecipientType type) {
        List addresses = (List)this.get(type);
        if (addresses == null) {
            return "";
        }
        return addresses.stream().map(InternetAddress::getAddress).collect(Collectors.joining(", "));
    }

    public String serialize() {
        StringBuilder result = new StringBuilder();
        for (Message.RecipientType type : RECIPIENT_TYPES) {
            List addressList = (List)this.get(type);
            if (addressList == null || addressList.isEmpty()) continue;
            StringBuilder part = new StringBuilder();
            for (InternetAddress addr : addressList) {
                Utils.addCommaSeparated(part, addr.getAddress());
            }
            if (type != Message.RecipientType.TO) {
                part.insert(0, type.toString().toUpperCase() + ": ");
            }
            Utils.addSeparated(result, ", ", part.toString());
        }
        return result.toString();
    }

    public LinkedHashMap<Message.RecipientType, InternetAddress[]> recipients() {
        LinkedHashMap<Message.RecipientType, InternetAddress[]> result = new LinkedHashMap<Message.RecipientType, InternetAddress[]>();
        for (Message.RecipientType type : RECIPIENT_TYPES) {
            List addresses = (List)this.get(type);
            if (addresses == null) continue;
            result.put(type, addresses.toArray(new InternetAddress[0]));
        }
        return result;
    }
}

