/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.util.log;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import org.apache.log4j.WriterAppender;
import org.bgerp.util.log.TrackedSession;

public class SessionLogAppender
extends WriterAppender {
    private static final Map<Thread, TrackedSession> TRACKED = new ConcurrentHashMap<Thread, TrackedSession>();

    public SessionLogAppender() {
        this.setWriter(new SessionBufferWriter(this));
    }

    public static final void track(HttpSession session, boolean create) {
        TrackedSession tracked = SessionLogAppender.getTracked(session);
        if (tracked == null && create) {
            tracked = new TrackedSession(session);
        }
        if (tracked != null) {
            TRACKED.put(Thread.currentThread(), tracked);
        }
    }

    public static final void untrack() {
        TRACKED.remove(Thread.currentThread());
    }

    public static final void untrack(HttpSession session) {
        TRACKED.values().removeIf(tracked -> tracked.session == session);
    }

    public static TrackedSession getTracked() {
        return TRACKED.get(Thread.currentThread());
    }

    public static boolean isTracked(HttpSession session) {
        return SessionLogAppender.getTracked(session) != null;
    }

    private static TrackedSession getTracked(HttpSession session) {
        return TRACKED.values().stream().filter(ts -> ts.session == session).findAny().orElse(null);
    }

    public static final String getSessionLog(HttpSession session) {
        StringBuilder result = new StringBuilder(200000);
        TrackedSession tracked = TRACKED.values().stream().filter(ts -> ts.session == session).findAny().orElse(null);
        if (tracked != null) {
            for (Object line : tracked.buffer) {
                result.append((char[])line);
            }
        }
        return result.toString();
    }

    private class SessionBufferWriter
    extends Writer {
        private SessionBufferWriter(SessionLogAppender sessionLogAppender) {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            TrackedSession tracked = TRACKED.get(Thread.currentThread());
            if (tracked != null) {
                tracked.buffer.add((Object)Arrays.copyOfRange(cbuf, off, off + len));
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

