/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.sec.auth.config;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javassist.NotFoundException;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.dao.expression.Expression;
import org.bgerp.plugin.sec.auth.AuthResult;
import org.bgerp.plugin.sec.auth.config.LDAPAttributes;
import org.bgerp.util.Log;
import ru.bgcrm.model.user.User;
import ru.bgcrm.util.Utils;

public class LdapAuthConfig
extends Config {
    private static final Log log = Log.getLog();
    private final String title;
    private final String url;
    private final String loginExpression;
    private final String searchBase;
    private final String searchExpression;
    private final String searchAttributes;
    private final String groupIdsExpression;
    private final String titleExpression;

    LdapAuthConfig(int id, ConfigMap config) throws Config.InitStopException {
        super(null);
        this.title = config.get("title", String.valueOf(id));
        this.url = config.get("url");
        this.loginExpression = config.get("login.expression");
        this.searchBase = config.get("search.base");
        this.searchExpression = config.get("search.expression");
        this.searchAttributes = config.get("search.attributes");
        this.groupIdsExpression = config.get("group.ids.expression");
        this.titleExpression = config.get("title.expression", "attrs.value(\"name\")");
        this.initWhen(Utils.notBlankStrings(this.url, this.loginExpression, this.searchBase, this.searchExpression, this.groupIdsExpression, this.titleExpression));
    }

    public AuthResult auth(String login, String password) {
        try {
            String searchFilter = new Expression(Map.of("login", login)).executeGetString(this.searchExpression);
            Attributes attrs = this.searchAttributes(login, password, searchFilter);
            return new AuthResult(this.user(login, password, new LDAPAttributes(attrs)));
        }
        catch (CommunicationException e) {
            log.error("LDAP communication exception", e);
            return new AuthResult(e.getCause());
        }
        catch (Exception e) {
            log.debug("LDAP auth exception", e);
            return new AuthResult(e);
        }
    }

    private User user(String login, String password, LDAPAttributes attrs) throws NamingException {
        log.debug("Found LDAP attributes for login {}: {}", login, attrs);
        User user = new User(login, "");
        user.setStatus(2);
        user.setTitle(new Expression(Map.of("attrs", attrs)).executeGetString(this.titleExpression));
        user.setGroupIds(this.getGroupIds(attrs));
        return user;
    }

    @VisibleForTesting
    protected Attributes searchAttributes(String login, String password, String searchFilter) throws NamingException, NotFoundException {
        InitialDirContext context = new InitialDirContext(this.buildEnvironment(login, password));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        if (Utils.notBlankString(this.searchAttributes)) {
            constraints.setReturningAttributes(Utils.toList(this.searchAttributes).toArray(new String[0]));
        }
        NamingEnumeration<SearchResult> answer = context.search(this.searchBase, searchFilter, constraints);
        context.close();
        if (answer.hasMore()) {
            return answer.next().getAttributes();
        }
        throw new NotFoundException("User not found");
    }

    private Hashtable<String, String> buildEnvironment(String login, String password) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.url);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", new Expression(Map.of("login", login)).executeGetString(this.loginExpression));
        env.put("java.naming.security.credentials", password);
        return env;
    }

    private Set<Integer> getGroupIds(LDAPAttributes attrs) throws NamingException {
        Set result = (Set)new Expression(Map.of("attrs", attrs)).execute(this.groupIdsExpression);
        return Collections.unmodifiableSet(result);
    }

    public String toString() {
        return LdapAuthConfig.class.getSimpleName() + " [" + this.title + "]";
    }
}

