/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.msg.email.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.model.param.ParameterEmailValue;
import ru.bgcrm.util.Utils;

public class EMailDAO
extends CommonDAO {
    public EMailDAO(Connection con) {
        super(con);
    }

    public List<ParameterEmailValue> getProcessEmails(int processId) throws SQLException {
        ArrayList<ParameterEmailValue> result = new ArrayList<ParameterEmailValue>(100);
        String query = "SELECT param.value, param.comment, param.comment FROM  param_email AS param INNER JOIN  param_pref AS pref ON param.param_id=pref.id AND pref.object=? WHERE param.id=?";
        try (PreparedQuery pq = new PreparedQuery(this.con, query);){
            pq.addString("process");
            pq.addInt(processId);
            this.loadEmails(pq, result);
        }
        return result;
    }

    public List<ParameterEmailValue> getUserEmails(Set<Integer> ids) throws SQLException {
        ArrayList<ParameterEmailValue> result = new ArrayList<ParameterEmailValue>(100);
        String query = "SELECT param.value, param.comment, user.title FROM  param_email AS param INNER JOIN  param_pref AS pref ON param.param_id=pref.id AND pref.object=? INNER JOIN  user AS user ON param.id=user.id AND user.status!=?";
        try (PreparedQuery pq = new PreparedQuery(this.con, query);){
            pq.addString("user");
            pq.addInt(1);
            if (ids != null && !ids.isEmpty()) {
                pq.addQuery(" AND user.id IN (" + Utils.toString(ids) + ")");
            }
            this.loadEmails(pq, result);
        }
        return result;
    }

    public List<ParameterEmailValue> getCustomerEmails(Set<Integer> ids) throws SQLException {
        ArrayList<ParameterEmailValue> result = new ArrayList<ParameterEmailValue>(100);
        String query = "SELECT param.value, param.comment, c.title FROM  param_email AS param INNER JOIN  param_pref AS pref ON param.param_id=pref.id AND pref.object=? INNER JOIN  customer AS c ON param.id=c.id";
        try (PreparedQuery pq = new PreparedQuery(this.con, query);){
            pq.addString("customer");
            if (ids != null && !ids.isEmpty()) {
                pq.addQuery(" AND c.id IN (" + Utils.toString(ids) + ")");
            }
            this.loadEmails(pq, result);
        }
        return result;
    }

    private void loadEmails(PreparedQuery pq, List<ParameterEmailValue> result) throws SQLException {
        ResultSet rs = pq.executeQuery();
        while (rs.next()) {
            ParameterEmailValue value = new ParameterEmailValue(rs.getString(1), rs.getString(2));
            if (Utils.isBlankString(value.getUsername())) continue;
            if (Utils.isBlankString(value.getComment())) {
                value.setComment(rs.getString(3));
            }
            result.add(value);
        }
    }
}

