/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.git;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.l10n.Localization;
import org.bgerp.cache.UserCache;
import org.bgerp.dao.param.ParamValueDAO;
import ru.bgcrm.event.ParamChangedEvent;
import ru.bgcrm.event.process.ProcessChangingEvent;
import ru.bgcrm.model.param.ParameterEmailValue;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.user.User;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

public class Config
extends org.bgerp.app.cfg.Config {
    private final String prefix;
    private final String mainBranch;
    private final int paramBranchId;
    private final int paramEmailId;
    private final Set<Integer> statusWithBranchIds;
    private final String createBranchSuffix;

    protected Config(ConfigMap config) throws Config.InitStopException {
        super(null);
        config = config.sub("git:");
        this.paramBranchId = config.getInt("param.branch");
        this.paramEmailId = config.getInt("param.email");
        this.statusWithBranchIds = Collections.unmodifiableSet(Utils.toIntegerSet(config.get("process.allowed.status.with.branch")));
        this.prefix = config.get("prefix", "p");
        this.mainBranch = config.get("main.branch", "master");
        this.createBranchSuffix = config.get("create.branch.suffix", "");
        this.initWhen(this.paramBranchId > 0);
    }

    public void paramChanged(ParamChangedEvent e, ConnectionSet conSet) throws Exception {
        if (e.getParameter().getId() != this.paramBranchId) {
            return;
        }
        Object value = (String)e.getValue();
        String prefix = this.prefix(e.getObjectId()) + "-";
        if (Utils.notBlankString((String)value) && !((String)value).startsWith(prefix)) {
            value = prefix + ((String)value).replace("_", "-");
            new ParamValueDAO(conSet.getConnection()).updateParamText(e.getObjectId(), this.paramBranchId, (String)value);
        }
    }

    public void processChanging(ProcessChangingEvent e, ConnectionSet conSet) throws SQLException, BGMessageException {
        if (!e.isStatus() || this.statusWithBranchIds.isEmpty() || this.statusWithBranchIds.contains(e.getStatusChange().getStatusId())) {
            return;
        }
        String branchName = this.branch(conSet, e.getProcess().getId());
        if (Utils.isBlankString(branchName)) {
            return;
        }
        throw new BGMessageException(Localization.getLocalizer("git", e.getForm().getHttpRequest()), "You can't change to the status when GIT branch isn't empty", new Object[0]);
    }

    public String mainBranch() {
        return this.mainBranch;
    }

    public String prefix(int processId) {
        return this.prefix + processId;
    }

    public String branch(ConnectionSet conSet, int processId) throws SQLException {
        return new ParamValueDAO(conSet.getSlaveConnection()).getParamText(processId, this.paramBranchId);
    }

    public String author(ConnectionSet conSet, Process p) throws Exception {
        Integer userId = Utils.getFirst(p.getExecutorIds().size() > 1 ? p.getExecutorIdsWithRole(0) : p.getExecutorIds());
        if (userId == null) {
            return null;
        }
        User user = UserCache.getUser(userId);
        ParameterEmailValue email = Utils.getFirst(new ParamValueDAO(conSet.getSlaveConnection()).getParamEmail(userId, this.paramEmailId).values());
        if (email == null) {
            return null;
        }
        return (Utils.notBlankString(email.getComment()) ? email.getComment() : user.getTitle()) + " <" + email.getValue() + ">";
    }

    public String getCreateBranchSuffix() {
        return this.createBranchSuffix;
    }
}

