/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bil.invoice.action;

import java.sql.Connection;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.dao.customer.CustomerDAO;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.dao.process.ProcessLogDAO;
import org.bgerp.model.Pageable;
import org.bgerp.plugin.bil.invoice.Config;
import org.bgerp.plugin.bil.invoice.dao.InvoiceDAO;
import org.bgerp.plugin.bil.invoice.dao.InvoiceSearchDAO;
import org.bgerp.plugin.bil.invoice.event.InvoiceChangedEvent;
import org.bgerp.plugin.bil.invoice.event.InvoicePaidEvent;
import org.bgerp.plugin.bil.invoice.model.Invoice;
import org.bgerp.plugin.bil.invoice.model.InvoiceType;
import org.bgerp.plugin.bil.invoice.model.Position;
import org.bgerp.util.Log;
import org.bgerp.util.TimeConvert;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.model.customer.Customer;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/plugin/invoice/invoice")
public class InvoiceAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/user/plugin/invoice";

    public ActionForward list(DynActionForm form, ConnectionSet conSet) throws Exception {
        new InvoiceSearchDAO(conSet.getSlaveConnection()).withProcessId(form.getParamInt("processId")).orderDefault().search(new Pageable<Invoice>(form));
        form.setRequestAttribute("config", this.setup.getConfig(Config.class));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/invoice/process/list.jsp");
    }

    public ActionForward create(DynActionForm form, ConnectionSet conSet) throws Exception {
        int processId = form.getParamInt("processId", val -> val > 0);
        int typeId = form.getParamInt("typeId");
        if (typeId > 0) {
            Config config = this.setup.getConfig(Config.class);
            YearMonth monthFrom = form.getParamYearMonth("monthFrom", Objects::nonNull);
            YearMonth monthTo = form.getParamYearMonth("monthTo", val -> val != null && !val.isBefore(monthFrom));
            Invoice invoice = config.getType(typeId).invoice(conSet, processId, monthFrom, monthTo);
            EventProcessor.processEvent(new InvoiceChangedEvent(form, invoice, InvoiceChangedEvent.Mode.CREATED), conSet);
            form.setResponseData("invoice", invoice);
            form.setResponseData("positions", config.getPositions());
            return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/invoice/edit.jsp");
        }
        Pageable<Invoice> invoices = new Pageable<Invoice>();
        new InvoiceSearchDAO(conSet.getSlaveConnection()).withProcessId(processId).orderDefault().search(invoices);
        Invoice lastInvoice = Utils.getFirst(invoices.getList());
        if (lastInvoice != null) {
            form.setRequestAttribute("typeId", lastInvoice.getTypeId());
            YearMonth monthFrom = TimeConvert.toYearMonth(lastInvoice.getDateFrom());
            YearMonth monthTo = TimeConvert.toYearMonth(lastInvoice.getDateTo());
            long delta = ChronoUnit.MONTHS.between(monthFrom, monthTo);
            monthFrom = monthTo.plusMonths(1L);
            monthTo = monthFrom.plusMonths(delta);
            form.setRequestAttribute("monthFrom", TimeUtils.format(TimeConvert.toDate(monthFrom), "ymd"));
            form.setRequestAttribute("monthTo", TimeUtils.format(TimeConvert.toDate(monthTo), "ymd"));
        }
        form.setRequestAttribute("types", this.setup.getConfig(Config.class).getTypes());
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/invoice/process/create.jsp");
    }

    public ActionForward get(DynActionForm form, ConnectionSet conSet) throws Exception {
        Invoice invoice = new InvoiceDAO(conSet.getConnection()).getOrThrow(form.getId());
        form.setResponseData("invoice", invoice);
        form.setResponseData("positions", this.setup.getConfig(Config.class).getPositions());
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/invoice/edit.jsp");
    }

    public ActionForward update(DynActionForm form, ConnectionSet conSet) throws Exception {
        Invoice invoice;
        InvoiceDAO dao = new InvoiceDAO(conSet.getConnection());
        if (form.getId() <= 0) {
            int typeId = form.getParamInt("typeId", val -> val > 0);
            int processId = form.getParamInt("processId", val -> val > 0);
            YearMonth monthFrom = form.getParamYearMonth("monthFrom", Objects::nonNull);
            YearMonth monthTo = form.getParamYearMonth("monthTo", val -> val != null && !val.isBefore(monthFrom));
            InvoiceType type = this.setup.getConfig(Config.class).getType(typeId);
            invoice = type.invoice(conSet, processId, monthFrom, monthTo);
            type.getNumberProvider().number(conSet.getConnection(), type, invoice);
            new ProcessLogDAO(conSet.getConnection()).insertEntityLog(invoice.getProcessId(), form.getUserId(), Log.format("Invoice {} created.", invoice.getNumber()));
        } else {
            invoice = dao.get(form.getId());
        }
        ArrayList<Position> positions = new ArrayList<Position>();
        List<String> ids = form.getParamValuesListStr("pos_id");
        List<String> titles = form.getParamValuesListStr("pos_title");
        List<String> amounts = form.getParamValuesListStr("pos_amount");
        List<String> units = form.getParamValuesListStr("pos_unit");
        List<Integer> quantities = form.getParamValuesList("pos_quantity");
        for (int i = 0; i < ids.size(); ++i) {
            positions.add(new Position(ids.get(i), titles.get(i), Utils.parseBigDecimal(amounts.get(i)), units.get(i), quantities.get(i)));
        }
        invoice.setPositions(positions);
        invoice.amount();
        dao.update(invoice);
        EventProcessor.processEvent(new InvoiceChangedEvent(form, invoice, InvoiceChangedEvent.Mode.CHANGED), conSet);
        return this.json(conSet, form);
    }

    public ActionForward delete(DynActionForm form, ConnectionSet conSet) throws Exception {
        new InvoiceDAO(conSet.getConnection()).delete(form.getId());
        return this.json(conSet, form);
    }

    public static InvoiceType doc(ConnectionSet conSet, DynActionForm form, int id) throws Exception {
        Connection slaveCon = conSet.getSlaveConnection();
        Invoice invoice = new InvoiceDAO(slaveCon).getOrThrow(id);
        Process process = new ProcessDAO(slaveCon).getProcess(invoice.getProcessId());
        CustomerDAO customerDao = new CustomerDAO(slaveCon);
        ProcessLinkDAO linkDao = new ProcessLinkDAO(slaveCon);
        ParamValueDAO paramDao = new ParamValueDAO(slaveCon);
        Config config = Setup.getSetup().getConfig(Config.class);
        InvoiceType type = config.getType(invoice.getTypeId());
        form.setResponseData("invoice", invoice);
        Customer invoiceCustomer = customerDao.getCustomerById(type.getCustomerId());
        if (invoiceCustomer != null) {
            form.setResponseData("invoiceCustomer", invoiceCustomer);
            form.setResponseData("invoiceCustomerParam", paramDao.parameters(invoiceCustomer));
        }
        form.setResponseData("process", process);
        form.setResponseData("processParam", paramDao.parameters(process));
        Customer customer = Utils.getFirst(linkDao.getLinkCustomers(process.getId(), null));
        if (customer != null) {
            form.setResponseData("customer", customer);
            form.setResponseData("customerParam", paramDao.parameters(customer));
        }
        return type;
    }

    public ActionForward doc(DynActionForm form, ConnectionSet conSet) throws Exception {
        InvoiceType type = InvoiceAction.doc(conSet, form, form.getId());
        return this.html(conSet, form, type.getJsp());
    }

    public ActionForward paid(DynActionForm form, ConnectionSet conSet) throws Exception {
        InvoiceDAO dao = new InvoiceDAO(conSet.getConnection());
        Invoice invoice = dao.getOrThrow(form.getId());
        invoice.setPaymentDate(form.getParamDate("date", new Date()));
        invoice.setPaymentUserId(form.getUserId());
        dao.update(invoice);
        new ProcessLogDAO(conSet.getConnection()).insertEntityLog(invoice.getProcessId(), form.getUserId(), Log.format("Invoice {} paid.", invoice.getNumber()));
        EventProcessor.processEvent(new InvoicePaidEvent(form, invoice), conSet);
        return this.json(conSet, form);
    }

    public ActionForward unpaid(DynActionForm form, ConnectionSet conSet) throws Exception {
        InvoiceDAO dao = new InvoiceDAO(conSet.getConnection());
        Invoice invoice = dao.getOrThrow(form.getId());
        invoice.setPaymentDate(null);
        invoice.setPaymentUserId(0);
        dao.update(invoice);
        new ProcessLogDAO(conSet.getConnection()).insertEntityLog(invoice.getProcessId(), form.getUserId(), Log.format("Invoice {} unpaid.", invoice.getNumber()));
        return this.json(conSet, form);
    }
}

