/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.process;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.dao.process.ProcessQueueDAO;
import org.bgerp.util.Log;
import ru.bgcrm.model.process.queue.Queue;
import ru.bgcrm.model.user.User;
import ru.bgcrm.struts.form.DynActionForm;

public class FilterEntryCounter
extends Thread {
    private Log log = Log.getLog();
    private static final long TIMEOUT = 60000L;
    private static FilterEntryCounter instance;
    private static Map<String, CountAndTime> queries;

    private FilterEntryCounter() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FilterEntryCounter getInstance() {
        if (instance != null) return instance;
        Class<FilterEntryCounter> clazz = FilterEntryCounter.class;
        synchronized (FilterEntryCounter.class) {
            if (instance != null) return instance;
            instance = new FilterEntryCounter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                this.updateQueries();
                this.removeOldQueries();
                continue;
            }
            catch (Exception e) {
                this.log.error(e);
                continue;
            }
            finally {
                try {
                    Thread.sleep(60000L);
                }
                catch (Exception exception) {}
                continue;
            }
            break;
        }
    }

    private void updateQueries() {
        try (Connection con = Setup.getSetup().getConnectionPool().getDBSlaveConnectionFromPool();){
            for (String query : queries.keySet()) {
                this.countQuery(con, query);
            }
        }
        catch (Exception e) {
            this.log.error(e);
        }
    }

    private int countQuery(Connection con, String query) throws SQLException {
        int result = 0;
        PreparedStatement ps = con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
            CountAndTime cnt = new CountAndTime(result, System.currentTimeMillis());
            queries.put(query, cnt);
            this.log.debug("Put query size after: {}, count: {}, query: {}", queries.size(), cnt.count, query);
        }
        ps.close();
        return result;
    }

    private void removeOldQueries() {
        long interval = Setup.getSetup().getLong("filterEntryStorageInterval", 120000L);
        Long currentTime = Calendar.getInstance().getTimeInMillis();
        for (Map.Entry<String, CountAndTime> me : queries.entrySet()) {
            String query = me.getKey();
            CountAndTime value = me.getValue();
            if (currentTime - value.time <= interval) continue;
            queries.remove(query);
            this.log.debug("Remove query, size after: {}, currentTime: {}, cnt.time: {}, query: {}", queries.size(), currentTime, value.time, query);
        }
    }

    private int getCount(String query) {
        CountAndTime result = queries.get(query);
        if (result == null) {
            result = new CountAndTime(-1, System.currentTimeMillis());
            queries.put(query, result);
        }
        return result.count;
    }

    public int parseUrlAndGetCount(Queue queue, String url, User user) throws Exception {
        DynActionForm filterForm = new DynActionForm(url);
        filterForm.setUser(user);
        String query = new ProcessQueueDAO(null, filterForm).getCountQuery(queue, filterForm);
        return this.getCount(query);
    }

    public int parseUrlAndGetCountSync(Queue queue, String url, User user) throws Exception {
        DynActionForm filterForm = new DynActionForm(url);
        filterForm.setUser(user);
        String query = new ProcessQueueDAO(null).getCountQuery(queue, filterForm);
        if (queries.containsKey(query)) {
            return this.getCount(query);
        }
        int result = 0;
        try (Connection con = Setup.getSetup().getConnectionPool().getDBSlaveConnectionFromPool();){
            result = this.countQuery(con, query);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
        }
        return result;
    }

    static {
        queries = new ConcurrentHashMap<String, CountAndTime>();
    }

    private static class CountAndTime {
        public volatile int count;
        public volatile long time;

        public CountAndTime(int count, long time) {
            this.count = count;
            this.time = time;
        }
    }
}

