/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.action;

import java.sql.Connection;
import java.util.stream.Collectors;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.ParameterCache;
import org.bgerp.dao.customer.CustomerDAO;
import org.bgerp.dao.customer.CustomerParamSearchDAO;
import org.bgerp.dao.process.ProcessParamSearchDAO;
import org.bgerp.model.Pageable;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.sql.LikePattern;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.customer.Customer;
import ru.bgcrm.model.param.ParameterSearchedObject;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/search", pathId=true)
public class SearchAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/user/search";
    private static final String JSP_DEFAULT = "/WEB-INF/jspf/user/search/search.jsp";
    private static final String PATH_JSP_CUSTOMER = "/WEB-INF/jspf/user/search/customer";
    private static final String JSP_CUSTOMER = "/WEB-INF/jspf/user/search/customer/customer.jsp";
    private static final String JSP_CUSTOMER_PARAM = "/WEB-INF/jspf/user/search/customer/param.jsp";
    private static final String PATH_JSP_PROCESS = "/WEB-INF/jspf/user/search/process";
    private static final String JSP_PROCESS = "/WEB-INF/jspf/user/search/process/process.jsp";
    private static final String JSP_PROCESS_PARAM = "/WEB-INF/jspf/user/search/process/param.jsp";

    @Override
    public ActionForward unspecified(DynActionForm form, Connection con) throws Exception {
        form.setRequestAttribute("customerParamTextList", ParameterCache.getObjectTypeParameterList("customer").stream().filter(p -> p.getTypeType() == Parameter.Type.TEXT).collect(Collectors.toList()));
        form.setRequestAttribute("processParamTextList", ParameterCache.getObjectTypeParameterList("process").stream().filter(p -> p.getTypeType() == Parameter.Type.TEXT).collect(Collectors.toList()));
        return this.html(con, form, JSP_DEFAULT);
    }

    public ActionForward customerSearch(DynActionForm form, ConnectionSet conSet) throws Exception {
        CustomerDAO customerDao = new CustomerDAO(conSet.getSlaveConnection());
        String searchBy = form.getParam("searchBy");
        if ("id".equals(searchBy)) {
            Pageable result = new Pageable(form);
            int id = Utils.parseInt(form.getParam("id"));
            Customer customer = customerDao.getCustomerById(id);
            if (customer != null) {
                result.getList().add(customer);
                result.getPage().setRecordCount(1);
            } else {
                result.getPage().setRecordCount(0);
            }
            return this.html(conSet, form, JSP_CUSTOMER);
        }
        if ("title".equals(searchBy)) {
            Pageable<Customer> result = new Pageable<Customer>(form);
            String title = form.getParam("title", "");
            long minLength = this.setup.getSokLong(0L, "search.customer.title.min.substring.length", "searchCustomerTitleMinSubstringLength");
            if ((long)title.length() < minLength) {
                throw new BGMessageException("Search string must be {} or more chars!", minLength);
            }
            customerDao.searchCustomerList(result, LikePattern.SUB.get(title));
            return this.html(conSet, form, JSP_CUSTOMER);
        }
        if ("address".equals(searchBy)) {
            Pageable<ParameterSearchedObject<Customer>> result = new Pageable<ParameterSearchedObject<Customer>>(form);
            int streetId = Utils.parseInt(form.getParam("streetId"));
            String house = form.getParam("house");
            String flat = form.getParam("flat");
            String room = form.getParam("room");
            customerDao.searchCustomerListByAddress(result, Utils.getObjectIdsList(ParameterCache.getObjectTypeParameterList("customer")), streetId, house, flat, room);
            return this.html(conSet, form, JSP_CUSTOMER_PARAM);
        }
        if ("text".equals(searchBy)) {
            Pageable<ParameterSearchedObject<Customer>> result = new Pageable<ParameterSearchedObject<Customer>>(form);
            String text = form.getParam("text");
            if (Utils.notBlankString(text)) {
                new CustomerParamSearchDAO(conSet.getSlaveConnection()).withParamTextValue(LikePattern.of(form.getParam("textLikeMode")).get(text)).withParamTextIds(form.getParamValues("textParam")).search(result);
            }
            return this.html(conSet, form, JSP_CUSTOMER_PARAM);
        }
        return this.html(conSet, form, JSP_DEFAULT);
    }

    public ActionForward customerSearchProcessLink(DynActionForm form, ConnectionSet conSet) throws Exception {
        this.customerSearch(form, conSet);
        return this.html(conSet, form, "/WEB-INF/jspf/user/process/process/link/list_search_customer.jsp");
    }

    public ActionForward processSearch(DynActionForm form, ConnectionSet conSet) throws Exception {
        ProcessDAO processDao = new ProcessDAO(conSet.getSlaveConnection(), form);
        String searchBy = form.getParam("searchBy");
        if ("userId".equals(searchBy)) {
            int mode = form.getParamInt("mode");
            processDao.searchProcessListForUser(new Pageable<Process>(form), form.getUserId(), mode);
            return this.html(conSet, form, JSP_PROCESS);
        }
        if ("id".equals(searchBy)) {
            Pageable result = new Pageable(form);
            Process process = processDao.getProcess(form.getId());
            if (process != null) {
                result.getList().add(process);
                result.getPage().setRecordCount(1);
            }
            return this.html(conSet, form, JSP_PROCESS);
        }
        if ("text".equals(searchBy)) {
            Pageable<ParameterSearchedObject<Process>> result = new Pageable<ParameterSearchedObject<Process>>(form);
            String text = form.getParam("text");
            if (Utils.notBlankString(text)) {
                new ProcessParamSearchDAO(conSet.getSlaveConnection(), form).withOpen(form.getParamBoolean("open", null)).withParamTextValue(LikePattern.of(form.getParam("textLikeMode")).get(text)).withParamTextIds(form.getParamValues("textParam")).search(result);
            }
            return this.html(conSet, form, JSP_PROCESS_PARAM);
        }
        return this.html(conSet, form, JSP_DEFAULT);
    }
}

