/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.slack.dao;

import com.fasterxml.jackson.databind.JsonNode;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.ParameterCache;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.cache.UserCache;
import org.bgerp.dao.param.OldParamSearchDAO;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.Pageable;
import org.bgerp.model.msg.Message;
import org.bgerp.model.msg.config.MessageTypeConfig;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.Log;
import ru.bgcrm.dao.PropertiesDAO;
import ru.bgcrm.dao.expression.Expression;
import ru.bgcrm.dao.message.MessageDAO;
import ru.bgcrm.dao.message.MessageType;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.event.process.ProcessMessageAddedEvent;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.slack.dao.SlackProto;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;
import ru.bgcrm.util.sql.SingleConnectionSet;

@Bean
public class MessageTypeChannel
extends MessageType {
    private static final Log log = Log.getLog();
    private static final String LAST_CHECK_PARAM = "slack:lastCheck";
    private final String token;
    private final String purposeExpression;
    private final String postExpression;
    private final Parameter accountParam;
    private final String stringExpressionMessageExtract;

    public MessageTypeChannel(Setup setup, int id, ConfigMap config) throws Config.InitStopException {
        super(setup, id, config.get("title"), config);
        this.token = config.get("authToken");
        if (this.token == null) {
            log.info("authToken is not defined.", new Object[0]);
            throw new Config.InitStopException();
        }
        this.purposeExpression = config.get("purposeExpression");
        this.postExpression = config.get("postExpression");
        this.accountParam = ParameterCache.getParameter(config.getInt("accountParamId", 0));
        this.stringExpressionMessageExtract = config.get("expressionMessageExtract");
    }

    public String getToken() {
        return this.token;
    }

    public String getPurposeExpression() {
        return this.purposeExpression;
    }

    public String getPostExpression() {
        return this.postExpression;
    }

    public Parameter getAccountParam() {
        return this.accountParam;
    }

    @Override
    public boolean isEditable(Message message) {
        return false;
    }

    @Override
    public boolean isRemovable(Message message) {
        return false;
    }

    @Override
    public boolean isAttachmentSupport() {
        return false;
    }

    @Override
    public String getHeaderJsp() {
        return "/WEB-INF/jspf/user/plugin/slack/process_link_list.jsp";
    }

    @Override
    public String getProcessMessageHeaderColor(Message message) {
        return "#E9C4F5";
    }

    @Override
    public void messageDelete(ConnectionSet conSet, String ... messageId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateMessage(Connection con, DynActionForm form, Message message) throws Exception {
        String slackAccount;
        int processId = message.getProcessId();
        SlackProto proto = new SlackProto(MessageTypeChannel.getMessageType().getToken());
        CommonObjectLink link = Utils.getFirst(new ProcessLinkDAO(con).getObjectLinksWithType(processId, "slack-channel"));
        if (link == null) {
            throw new BGMessageException("\u041a \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0443 \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u043a\u0430\u043d\u0430\u043b Slack.", new Object[0]);
        }
        String username = null;
        if (this.accountParam != null && Utils.notBlankString(slackAccount = new ParamValueDAO(con).getParamText(message.getUserId(), this.accountParam.getId()))) {
            username = slackAccount;
        }
        JsonNode result = proto.chatPostMessage(link.getLinkObjectTitle(), message.getText(), username, null).get("message");
        message.setFrom("");
        message.setTo("");
        message.setSystemId(result.get("ts").asText());
        new MessageDAO(con).updateMessage(message);
    }

    @Override
    public void process() {
        log.debug("Processing Slack: {}", this.id);
        if (this.stringExpressionMessageExtract == null) {
            log.info("No stringExpressionMessageExtract - skipping processing", new Object[0]);
            return;
        }
        try (Connection con = this.setup.getDBConnectionFromPool();){
            PropertiesDAO propDAO = new PropertiesDAO(con);
            MessageDAO messageDAO = new MessageDAO(con);
            OldParamSearchDAO paramDAO = new OldParamSearchDAO(con);
            ProcessLinkDAO linkDAO = new ProcessLinkDAO(con);
            long lastCheck = Utils.parseLong(propDAO.get(LAST_CHECK_PARAM), 0L);
            log.debug("Last check: {}", lastCheck);
            SlackProto proto = new SlackProto(this.token);
            HashMap<String, String> accountMap = null;
            if (this.accountParam != null) {
                accountMap = new HashMap<String, String>();
                for (JsonNode n : proto.userList().get("members")) {
                    accountMap.put(n.get("id").asText(), n.get("name").asText());
                }
            }
            long newLastCheck = lastCheck;
            for (JsonNode channel : proto.channelList(true)) {
                String channelId = channel.get("id").asText();
                String name = channel.get("name").asText();
                log.debug("Channel: {}", name);
                Pageable<Pair<String, Process>> searchResult = new Pageable<Pair<String, Process>>();
                linkDAO.searchLinkedProcessList(searchResult, "slack-channel", 1, channelId, null, null, null, null);
                Pair<String, Process> pair = Utils.getFirst(searchResult.getList());
                if (pair == null) continue;
                Process process = pair.getSecond();
                for (JsonNode m : proto.channelHistory(channelId, lastCheck > 0L ? String.valueOf(lastCheck) : null).get("messages")) {
                    log.debug("Processing message: {}", m);
                    String text = m.get("text").asText();
                    long ts = Utils.parseLong(StringUtils.substringBefore((String)m.get("ts").asText(), (String)"."));
                    if (ts > newLastCheck) {
                        newLastCheck = ts;
                    }
                    HashMap<String, Object> ctx = new HashMap<String, Object>();
                    ctx.put("message", text);
                    ctx.put("m", m);
                    text = new Expression(ctx).executeGetString(this.stringExpressionMessageExtract);
                    if (text == null) continue;
                    int userId = 0;
                    if (this.accountParam != null) {
                        String slackLogin = (String)accountMap.get(m.get("user").asText());
                        Set<Integer> userIds = paramDAO.searchObjectByParameterText(this.accountParam.getId(), slackLogin);
                        if (!userIds.isEmpty()) {
                            userId = Utils.getFirst(userIds);
                        }
                    }
                    Message msg = new Message();
                    msg.setDirection(1);
                    msg.setTypeId(this.id);
                    msg.setText(text);
                    msg.setFromTime(new Date(ts * 1000L));
                    msg.setFrom("");
                    msg.setTo("");
                    msg.setProcessId(process.getId());
                    msg.setToTime(new Date());
                    msg.setUserId(userId);
                    messageDAO.updateMessage(msg);
                    log.info("Created message: " + msg.getId(), new Object[0]);
                    ProcessType type = ProcessTypeCache.getProcessType(process.getTypeId());
                    if (type == null) {
                        log.error("Not found process type with id:" + process.getTypeId(), new Object[0]);
                        continue;
                    }
                    DynActionForm form = DynActionForm.SYSTEM_FORM;
                    User user = UserCache.getUser(userId);
                    if (user != null) {
                        form = new DynActionForm(user);
                    }
                    EventProcessor.processEvent(new ProcessMessageAddedEvent(form, msg, process), new SingleConnectionSet(con));
                }
            }
            if (newLastCheck > 0L) {
                propDAO.set(LAST_CHECK_PARAM, String.valueOf(newLastCheck + 1L));
            }
            con.commit();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        }
    }

    public static MessageTypeChannel getMessageType() throws BGMessageException {
        MessageTypeChannel type = Setup.getSetup().getConfig(MessageTypeConfig.class).getMessageType(MessageTypeChannel.class);
        if (type == null) {
            throw new BGMessageException("\u041d\u0435 \u0441\u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d \u0442\u0438\u043f \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f Slack", new Object[0]);
        }
        return type;
    }
}

