/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.slack;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.msg.Message;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.plugin.slack.dao.MessageTypeChannel;
import ru.bgcrm.plugin.slack.dao.SlackProto;
import ru.bgcrm.struts.action.LinkAction;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.SQLUtils;

public class ExpressionObject
implements ru.bgcrm.dao.expression.ExpressionObject {
    @Override
    public void toContext(Map<String, Object> context) {
        context.put("slack", this);
    }

    public void linkChannel(Process process) {
        this.linkChannel(process, null);
    }

    public void linkChannel(Process process, String channelName) {
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try {
            ProcessLinkDAO linkDao = new ProcessLinkDAO(con);
            MessageTypeChannel type = MessageTypeChannel.getMessageType();
            SlackProto proto = new SlackProto(type.getToken());
            CommonObjectLink link = Utils.getFirst(linkDao.getObjectLinksWithType(process.getId(), "slack-channel"));
            if (link == null) {
                String channelId = proto.channelCreate(channelName != null ? channelName : String.valueOf(process.getId()), true);
                link = new CommonObjectLink("process", process.getId(), "slack-channel", 1, channelId);
                LinkAction.addLink(DynActionForm.SYSTEM_FORM, con, link);
            }
            con.commit();
        }
        catch (BGException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        finally {
            SQLUtils.closeConnection(con);
        }
    }

    public void inviteExecutors(Process process) {
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try {
            ProcessLinkDAO linkDao = new ProcessLinkDAO(con);
            ParamValueDAO paramDAO = new ParamValueDAO(con);
            MessageTypeChannel type = MessageTypeChannel.getMessageType();
            SlackProto proto = new SlackProto(type.getToken());
            if (type.getAccountParam() != null && !process.getExecutorIds().isEmpty()) {
                CommonObjectLink link = Utils.getFirst(linkDao.getObjectLinksWithType(process.getId(), "slack-channel"));
                if (link == null) {
                    return;
                }
                String channelId = link.getLinkObjectTitle();
                HashMap accountMap = new HashMap();
                for (int userId : process.getExecutorIds()) {
                    String slackAccount = paramDAO.getParamText(userId, type.getAccountParam().getId());
                    if (!Utils.notBlankString(slackAccount)) continue;
                    accountMap.put(slackAccount, null);
                }
                if (!accountMap.isEmpty()) {
                    proto.userList().get("members").forEach(n -> {
                        String name = n.get("name").asText();
                        if (accountMap.containsKey(name)) {
                            accountMap.put(name, n.get("id").asText());
                        }
                    });
                }
                ArrayList<String> userIds = new ArrayList<String>();
                for (Map.Entry me : accountMap.entrySet()) {
                    if (me.getValue() == null) {
                        throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0430\u043a\u043a\u0430\u0443\u043d\u0442 Slack: " + (String)me.getKey(), new Object[0]);
                    }
                    userIds.add((String)me.getValue());
                }
                if (!userIds.isEmpty()) {
                    proto.channelInviteUsers(channelId, userIds);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        finally {
            SQLUtils.closeConnection(con);
        }
    }

    public void setTopic(Process process, String topic) {
        this.findChannelAndDo(process, (proto, channelId) -> proto.channelSetTopic(channelId, topic));
    }

    public void setPurpose(Process process, String purpose) {
        this.findChannelAndDo(process, (proto, channelId) -> proto.channelSetPurpose(channelId, purpose));
    }

    public void archive(Process process, boolean archive) {
        this.findChannelAndDo(process, (proto, channelId) -> {
            if (archive) {
                proto.channelArchive(channelId);
            } else {
                proto.channelUnArchive(channelId);
            }
        });
    }

    public void sendMessage(Process process, int userId, String messageText) {
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try {
            MessageTypeChannel type = MessageTypeChannel.getMessageType();
            Message message = new Message();
            message.setUserId(userId);
            message.setTypeId(type.getId());
            message.setDirection(2);
            message.setFromTime(new Date());
            message.setProcessId(process.getId());
            message.setSubject("");
            message.setTo("");
            message.setText(messageText);
            type.updateMessage(con, DynActionForm.SYSTEM_FORM, message);
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        finally {
            SQLUtils.closeConnection(con);
        }
    }

    private void findChannelAndDo(Process process, ChannelOperation operation) {
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try {
            ProcessLinkDAO linkDao = new ProcessLinkDAO(con);
            MessageTypeChannel type = MessageTypeChannel.getMessageType();
            SlackProto proto = new SlackProto(type.getToken());
            CommonObjectLink link = Utils.getFirst(linkDao.getObjectLinksWithType(process.getId(), "slack-channel"));
            if (link != null) {
                String channelId = link.getLinkObjectTitle();
                operation.perform(proto, channelId);
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        finally {
            SQLUtils.closeConnection(con);
        }
    }

    private static interface ChannelOperation {
        public void perform(SlackProto var1, String var2) throws Exception;
    }
}

