/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.exception.BGException;
import org.bgerp.util.Log;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.util.Utils;

public class DBInfoManager {
    private static final Log log = Log.getLog();
    private static DBInfoManager instance;
    private Map<String, DBInfo> dbInfoMap = new HashMap<String, DBInfo>();
    private List<DBInfo> dbInfoList = new ArrayList<DBInfo>();
    static final String[] SUPPORTED_VERSIONS;

    private DBInfoManager(Setup setup) {
        String prefix = "bgbilling:server.";
        String prefixOld = "bgbilling.";
        for (Map.Entry<Integer, ConfigMap> me : setup.subSokIndexed("bgbilling:server.", "bgbilling.").entrySet()) {
            ConfigMap params = me.getValue();
            try {
                DBInfo dbInfo = new DBInfo(params.get("id"));
                dbInfo.setUrl(params.get("url"));
                dbInfo.setTitle(params.get("title"));
                dbInfo.setVersion(params.get("version", ""));
                dbInfo.setSetup(setup.subSok("bgbilling:server." + String.valueOf(me.getKey()) + ".", "bgbilling." + String.valueOf(me.getKey()) + "."));
                if (Utils.notBlankString(dbInfo.getVersion()) && !StringUtils.startsWithAny((CharSequence)dbInfo.getVersion(), (CharSequence[])SUPPORTED_VERSIONS)) {
                    throw new BGException("Unsupported billing version: {}", dbInfo.getVersion());
                }
                this.dbInfoMap.put(dbInfo.getId(), dbInfo);
                this.dbInfoList.add(dbInfo);
            }
            catch (Exception e) {
                log.error(Log.format("Parsing server: {}", me.getKey()), e);
            }
        }
    }

    public static void flush() {
        if (instance != null) {
            for (DBInfo dbInfo : instance.getDbInfoList()) {
                dbInfo.getConnectionPool().close();
            }
        }
        instance = null;
    }

    public static DBInfoManager getInstance() {
        if (instance == null) {
            instance = new DBInfoManager(Setup.getSetup());
        }
        return instance;
    }

    public static DBInfo getDbInfo(String billingId) {
        DBInfo dbInfo = DBInfoManager.getInstance().getDbInfoMap().get(billingId);
        if (dbInfo == null) {
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0431\u0438\u043b\u043b\u0438\u043d\u0433: {}", billingId);
        }
        return dbInfo;
    }

    public List<DBInfo> getDbInfoList() {
        return this.dbInfoList;
    }

    public Map<String, DBInfo> getDbInfoMap() {
        return this.dbInfoMap;
    }

    static {
        SUPPORTED_VERSIONS = new String[]{"10.2", "9.2", "8.2", "8.0", "7.2", "7.1", "7.0"};
    }
}

