/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Statement;
import org.bgerp.util.Dynamic;
import ru.bgcrm.dao.CommonDAO;

@Dynamic
public class Page {
    public static final int DEFAULT_PAGE_SIZE = 25;
    public static final String RECORD_COUNT = "recordCount";
    public static final String PAGE_COUNT = "pageCount";
    public static final String PAGE_INDEX = "pageIndex";
    public static final String PAGE_SIZE = "pageSize";
    public static final String PAGEABLE_ID = "pageableId";
    public static int PAGE_INDEX_NO_PAGING = -1;
    private int pageSize = 0;
    private int pageIndex = 1;
    private int pageCount = 0;
    private int recordCount = 0;

    public void setData(Page page) {
        this.pageSize = page.pageSize;
        this.pageIndex = page.pageIndex;
        this.pageCount = page.pageCount;
        this.recordCount = page.recordCount;
    }

    public boolean isPaginationEnabled() {
        return this.pageIndex > 0;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int value) {
        this.pageIndex = value;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public int getPageFirstRecordNumber() {
        return (this.getPageIndex() - 1) * this.getPageSize();
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public String getLimitSql() {
        StringBuilder sql = new StringBuilder(20);
        if (this.getPageSize() > 0 && this.getPageIndex() != PAGE_INDEX_NO_PAGING) {
            sql.append(" LIMIT ").append(this.getPageFirstRecordNumber()).append(", ").append(this.getPageSize());
        }
        return sql.toString();
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
        if (recordCount > 0 && this.pageSize > 0) {
            BigDecimal a = new BigDecimal(recordCount);
            BigDecimal b = a.divide(new BigDecimal(this.pageSize), RoundingMode.UP);
            this.pageCount = b.intValue();
            if (this.pageIndex > this.pageCount) {
                this.pageIndex = this.pageCount;
            }
        }
    }

    public void setRecordCount(Statement st) throws SQLException {
        this.setRecordCount(CommonDAO.foundRows(st));
    }
}

