/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao.expression;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.event.iface.Event;
import org.bgerp.event.base.UserEvent;
import org.bgerp.util.Log;
import org.bgerp.util.TimeConvert;
import ru.bgcrm.dao.expression.ProcessChangeExpressionObject;
import ru.bgcrm.dao.expression.ProcessExpressionObject;
import ru.bgcrm.dao.expression.ProcessLinkExpressionObject;
import ru.bgcrm.dao.expression.ProcessParamExpressionObject;
import ru.bgcrm.dao.expression.UserExpressionObject;
import ru.bgcrm.dao.expression.UserParamExpressionObject;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.servlet.filter.SetRequestParamsFilter;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

public class Expression {
    private static final Log log = Log.getLog();
    public static final String EXPRESSION_CONFIG_KEY = "expression";
    public static final String CHECK_EXPRESSION_CONFIG_KEY = "checkExpression";
    public static final String CHECK_ERROR_MESSAGE_CONFIG_KEY = "checkErrorMessage";
    public static final String DO_EXPRESSION_CONFIG_KEY = "doExpression";
    private static final Utils PREFIX_u = new Utils();
    private static final TimeUtils PREFIX_tu = new TimeUtils();
    private static final TimeConvert PREFIX_tc = new TimeConvert();
    private static final StringUtils PREFIX_su = new StringUtils();
    private static final CollectionUtils PREFIX_cu = new CollectionUtils();
    private static final FileUtils PREFIX_fu = new FileUtils();
    private JexlEngine jexl;
    private JexlContext context = new MapContext(this){

        public boolean has(String name) {
            try {
                return super.has(name) || Class.forName(name) != null;
            }
            catch (ClassNotFoundException xnf) {
                return false;
            }
        }

        public Object get(String name) {
            try {
                Class<?> found = super.get(name);
                if (found == null && !super.has(name)) {
                    found = Class.forName(name);
                }
                return found;
            }
            catch (ClassNotFoundException xnf) {
                return null;
            }
        }
    };

    public Expression(Map<String, Object> context) {
        context = new HashMap<String, Object>(context);
        try {
            EventProcessor.processEvent(new ContextInitEvent(context), null);
        }
        catch (Exception e) {
            log.error(e);
        }
        JexlBuilder jexlBuilder = new JexlBuilder().namespaces(context).strict(true).arithmetic(new JexlArithmetic(false));
        this.jexl = jexlBuilder.create();
        Expression.setExpressionContextUtils(context);
        context.put("log", log);
        context.put("NEW_LINE", "\n");
        context.put("NEW_LINE2", "\n\n");
        context.entrySet().stream().filter(me -> me.getKey() != null).forEach(me -> this.context.set((String)me.getKey(), me.getValue()));
    }

    public static void setExpressionContextUtils(Map<String, Object> contextVars) {
        contextVars.put("u", PREFIX_u);
        contextVars.put("tu", PREFIX_tu);
        contextVars.put("tc", PREFIX_tc);
        contextVars.put("su", PREFIX_su);
        contextVars.put("cu", PREFIX_cu);
        contextVars.put("fu", PREFIX_fu);
    }

    public boolean executeCheck(String expression) {
        return (Boolean)this.jexl.createScript(expression).execute(this.context);
    }

    public String executeGetString(String expression) {
        return (String)this.jexl.createScript(expression).execute(this.context);
    }

    public Object execute(String expression) {
        log.debug("Executing script: {}", expression);
        try {
            return this.jexl.createScript(expression).execute(this.context);
        }
        catch (JexlException e) {
            int lineNumber = Utils.parseInt(StringUtils.substringBetween((String)e.getMessage(), (String)"@", (String)":"));
            String[] lines = expression.split("\\n");
            if (lineNumber > 0 && lineNumber <= lines.length) {
                log.error("INCORRECT SCRIPT LINE: " + lines[lineNumber - 1], new Object[0]);
            }
            throw e;
        }
    }

    public static Expression init(ConnectionSet conSet, UserEvent event, Process process) throws Exception {
        DynActionForm form = event.getForm();
        Map<String, Object> context = Expression.context(conSet, form, event, process);
        return new Expression(context);
    }

    public static Map<String, Object> context(ConnectionSet conSet, DynActionForm form, UserEvent event, Process process) {
        Connection con = conSet.getConnection();
        HashMap<String, Object> context = new HashMap<String, Object>(100);
        new ProcessChangeExpressionObject(process, form, con).toContext(context);
        new UserExpressionObject(form.getUser()).toContext(context);
        new UserParamExpressionObject(con, form.getUserId()).toContext(context);
        new ProcessExpressionObject(process).toContext(context);
        new ProcessParamExpressionObject(con, process.getId()).toContext(context);
        new ProcessLinkExpressionObject(con, process.getId()).toContext(context);
        context.put("conSet", conSet);
        context.put("form", (Object)form);
        if (event != null) {
            context.put("event", event);
        }
        context.putAll(SetRequestParamsFilter.getContextVariables(form.getHttpRequest()));
        return context;
    }

    public static final class ContextInitEvent
    implements Event {
        private final Map<String, Object> context;

        public ContextInitEvent(Map<String, Object> context) {
            this.context = context;
        }

        public Map<String, Object> getContext() {
            return this.context;
        }
    }
}

