/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.Pageable;
import ru.bgcrm.dao.CommonLinkDAO;
import ru.bgcrm.dao.CustomerDAO;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.customer.Customer;

public class CustomerLinkDAO
extends CommonLinkDAO {
    public CustomerLinkDAO(Connection con) {
        super(con);
    }

    @Override
    protected String getTable() {
        return " customer_link ";
    }

    @Override
    protected String getColumnName() {
        return "customer_id";
    }

    @Override
    protected String getObjectType() {
        return "customer";
    }

    public void searchCustomerByLink(Pageable<Customer> searchResult, CommonObjectLink link) {
        Page page = searchResult.getPage();
        List<Customer> list = searchResult.getList();
        try {
            String query = "SELECT * FROM  customer_link  AS link INNER JOIN  customer  AS c ON link.customer_id=c.id WHERE link.object_id=? AND link.object_type=? " + page.getLimitSql();
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, link.getLinkObjectId());
            ps.setString(2, link.getLinkObjectType());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(CustomerDAO.getCustomerFromRs(rs, ""));
            }
            if (page != null) {
                page.setRecordCount(ps);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }
}

