/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.msg.email;

import com.sun.mail.imap.IMAPMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.io.IOUtils;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.message.DefaultMessageWriter;
import org.apache.james.mime4j.stream.MimeConfig;
import org.bgerp.model.file.FileData;
import org.bgerp.util.Log;
import org.bgerp.util.mail.MailConfig;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import ru.bgcrm.util.Utils;

public class MessageParser {
    private static final Log log = Log.getLog();
    private static final Pattern DATE_PATTERN = Pattern.compile("\\w{3}, \\d+ \\w{3} \\d{4} \\d{2}:\\d{2}:\\d{2} \\+\\d{4}");
    private static final MailDateFormat MAIL_DATE_FORMAT = new MailDateFormat();
    private final MimeMessage message;
    private final byte[] mimeData;
    private Message mime4j;

    public MessageParser(javax.mail.Message message) {
        if (!(message instanceof IMAPMessage)) {
            throw new IllegalArgumentException("Parameter must be IMAPMessage");
        }
        this.message = (MimeMessage)message;
        this.mimeData = null;
    }

    MessageParser(InputStream inputStream) throws Exception {
        this.mimeData = IOUtils.toByteArray((InputStream)inputStream);
        this.message = new MimeMessage(Session.getInstance((Properties)MailConfig.getImapSessionStaticProperties()), (InputStream)new ByteArrayInputStream(this.mimeData));
    }

    public String getMessageId() throws MessagingException {
        return this.message.getMessageID();
    }

    public String getFrom() throws MessagingException {
        return ((InternetAddress)this.message.getFrom()[0]).getAddress();
    }

    public Date getFromTime() throws MessagingException {
        Matcher m;
        String[] headers = this.message.getHeader("Received");
        if (headers != null && headers.length > 0 && (m = DATE_PATTERN.matcher(headers[0])).find()) {
            try {
                return MAIL_DATE_FORMAT.parse(m.group());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.message.getSentDate();
    }

    public String getTo() throws Exception {
        String[] valuesCc;
        StringBuilder to = new StringBuilder(100);
        String[] valuesTo = this.message.getHeader("To");
        if (valuesTo != null) {
            this.extractAddresses(valuesTo, to);
        }
        if ((valuesCc = this.message.getHeader("CC")) != null) {
            StringBuilder cc = new StringBuilder(100);
            this.extractAddresses(valuesCc, cc);
            to.append("; CC: ").append((CharSequence)cc);
        }
        return to.toString();
    }

    private void extractAddresses(String[] values, StringBuilder result) {
        for (String value : values) {
            for (String token : Utils.toList(value)) {
                try {
                    Utils.addSeparated(result, ", ", InternetAddress.parse((String)token)[0].getAddress());
                }
                catch (AddressException e) {
                    log.error(e);
                }
            }
        }
    }

    public String getMessageSubject() throws Exception {
        return DecoderUtil.decodeEncodedWords((String)Utils.maskNull(this.message.getSubject()), (DecodeMonitor)DecodeMonitor.SILENT);
    }

    public String getTextContent() throws Exception {
        String textContent = new String();
        String contentType = this.message.getContentType().toLowerCase();
        Object content = this.message.getContent();
        log.debug("Extracting content, contentType: {}", contentType);
        if (contentType.startsWith("text/plain")) {
            textContent = (String)content;
        } else if (contentType.startsWith("text/html")) {
            textContent = this.htmlToPlainText((String)content);
        } else if (contentType.startsWith("multipart/alternative")) {
            textContent = this.getTextFromMultipartAlternative((MimeMultipart)this.message.getContent());
        } else if (contentType.startsWith("multipart/")) {
            textContent = this.getTextFromMultipartMixed((MimeMultipart)this.message.getContent());
        } else {
            return "Message type '" + contentType + "' is not supported";
        }
        return textContent.replace("\r", "").replaceAll("(\n\\s*){2,}", "\n\n").trim();
    }

    private String htmlToPlainText(String text) {
        return this.buildStringFromNode((Node)Jsoup.parse((String)text).body(), "").toString();
    }

    private StringBuffer buildStringFromNode(Node node, String citation) {
        StringBuffer buffer = new StringBuffer();
        if (node instanceof Element) {
            Element element = (Element)node;
            String tagName = element.tagName();
            if ("blockquote".equals(tagName)) {
                citation = "> " + (String)citation;
            } else if ("p".equals(tagName) || "div".equals(tagName) || "br".equals(tagName)) {
                buffer.append("\n");
            } else if ("a".equals(tagName)) {
                buffer.append(" [");
                Node firstChild = (Node)Utils.getFirst(node.childNodes());
                if (firstChild != null) {
                    buffer.append(this.buildStringFromNode(firstChild, (String)citation));
                }
                buffer.append("] ");
                buffer.append(element.attr("href"));
                return buffer;
            }
        }
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            buffer.append((String)citation + textNode.text().trim());
        }
        for (Node childNode : node.childNodes()) {
            buffer.append(this.buildStringFromNode(childNode, (String)citation));
        }
        return buffer;
    }

    private String getTextFromMultipartAlternative(MimeMultipart content) {
        String textContent = new String();
        try {
            for (int i = 0; i < content.getCount(); ++i) {
                BodyPart messagePart = content.getBodyPart(i);
                String partContentType = messagePart.getContentType().toLowerCase();
                Object partContent = messagePart.getContent();
                log.debug("Extracting multipart part, contentType: {}", partContentType);
                if (partContentType.startsWith("text/plain")) {
                    textContent = (String)partContent;
                    break;
                }
                if (!partContentType.startsWith("text/html")) continue;
                textContent = this.htmlToPlainText((String)partContent);
            }
        }
        catch (Exception ex) {
            log.error("Multipart alternative message error: " + ex.getMessage(), ex);
        }
        return textContent;
    }

    private String getTextFromMultipartMixed(MimeMultipart content) {
        String textContent = new String();
        try {
            for (int i = 0; i < content.getCount(); ++i) {
                BodyPart part = content.getBodyPart(i);
                String partContentType = part.getContentType().toLowerCase();
                Object partContent = part.getContent();
                log.debug("Processing multipart part, type: {}", partContentType);
                if (partContentType.startsWith("multipart/alternative")) {
                    textContent = this.getTextFromMultipartAlternative((MimeMultipart)partContent);
                    continue;
                }
                if (partContentType.startsWith("text/plain")) {
                    textContent = (String)partContent;
                    continue;
                }
                if (partContentType.startsWith("text/html")) {
                    textContent = this.htmlToPlainText((String)partContent);
                    continue;
                }
                if (!partContentType.startsWith("multipart/mixed") && !partContentType.startsWith("multipart/related")) continue;
                textContent = this.getTextFromMultipartMixed((MimeMultipart)part.getContent());
            }
        }
        catch (Exception ex) {
            log.error("Multipart mixed message error: " + ex.getMessage(), ex);
        }
        return textContent;
    }

    public List<FileData> getAttachContent() throws Exception {
        Body body;
        ArrayList<FileData> attachContent = new ArrayList<FileData>();
        if (this.mime4j == null) {
            DefaultMessageBuilder builder = new DefaultMessageBuilder();
            builder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
            this.mime4j = builder.parseMessage(this.mimeData != null ? new ByteArrayInputStream(this.mimeData) : ((IMAPMessage)this.message).getMimeStream());
        }
        if ((body = this.mime4j.getBody()) instanceof Multipart) {
            Multipart multipart = (Multipart)body;
            for (Entity part : multipart.getBodyParts()) {
                String filename = part.getFilename();
                log.debug("Possible attachment part, filename: {}", filename);
                if (Utils.isBlankString(filename)) {
                    log.debug("Skip", new Object[0]);
                    continue;
                }
                attachContent.add(new FileData(part.getFilename(), this.getContent(part.getBody())));
            }
        }
        return attachContent;
    }

    private byte[] getContent(Body body) throws IOException {
        DefaultMessageWriter messageWriter = new DefaultMessageWriter();
        ByteArrayOutputStream out = new ByteArrayOutputStream(20000);
        messageWriter.writeBody(body, (OutputStream)out);
        return out.toByteArray();
    }
}

