/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.file.tmp;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpSession;
import org.apache.struts.upload.FormFile;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.model.file.tmp.FileInfo;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

public class SessionTemporaryFiles {
    private static final String STORE_KEY = "SessionTemporaryFiles";
    private final AtomicInteger fileIndex = new AtomicInteger(1);
    private final Map<Integer, FileInfo> files = new ConcurrentHashMap<Integer, FileInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int upload(DynActionForm form) throws FileNotFoundException, IOException {
        HttpSession session = form.getHttpRequest().getSession(true);
        SessionTemporaryFiles files = null;
        HttpSession httpSession = session;
        synchronized (httpSession) {
            files = (SessionTemporaryFiles)session.getAttribute(STORE_KEY);
            if (files == null) {
                files = new SessionTemporaryFiles();
                session.setAttribute(STORE_KEY, (Object)files);
            }
        }
        FormFile file = form.getFile();
        String digest = Utils.getDigest(file.getFileData());
        int fileId = files.fileIndex.incrementAndGet();
        String path = Utils.getTmpDir() + "/" + session.getId() + "-" + fileId;
        try (FileOutputStream fos = new FileOutputStream(path);){
            fos.write(file.getFileData());
        }
        files.files.put(fileId, new FileInfo(file.getFileName(), path, digest));
        return fileId;
    }

    public static Map<Integer, FileInfo> getFiles(DynActionForm form, String paramName) throws BGMessageException {
        HashMap<Integer, FileInfo> result = new HashMap<Integer, FileInfo>();
        TreeSet<String> digests = new TreeSet<String>();
        if (form.getHttpRequest() != null) {
            HttpSession session = form.getHttpRequest().getSession(true);
            SessionTemporaryFiles files = (SessionTemporaryFiles)session.getAttribute(STORE_KEY);
            for (String tmpFileId : form.getParamValuesListStr("tmpFileId")) {
                int tmpFileIdInt = Utils.parseInt(tmpFileId);
                if (tmpFileIdInt <= 0) {
                    throw new BGException("Incorrect ID of tmp file: " + tmpFileId, new Object[0]);
                }
                FileInfo file = files.files.get(tmpFileIdInt);
                if (file == null) continue;
                if (!digests.add(file.getHash())) {
                    throw new BGMessageException("File '{}' was already uploaded", file.getTitle());
                }
                result.put(tmpFileIdInt, file);
            }
        }
        return result;
    }

    public static void deleteFiles(DynActionForm form, Set<Integer> ids) {
        if (form.getHttpRequest() != null) {
            HttpSession session = form.getHttpRequest().getSession(true);
            SessionTemporaryFiles files = (SessionTemporaryFiles)session.getAttribute(STORE_KEY);
            if (files == null) {
                return;
            }
            for (int tmpFileId : ids) {
                FileInfo file = files.files.remove(tmpFileId);
                if (file == null) continue;
                file.delete();
            }
        }
    }

    public static void deleteFiles(HttpSession session) {
        SessionTemporaryFiles files = (SessionTemporaryFiles)session.getAttribute(STORE_KEY);
        if (files != null) {
            files.files.values().stream().forEach(FileInfo::delete);
        }
    }
}

