/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model;

import java.util.ArrayList;
import java.util.List;
import org.bgerp.util.Dynamic;
import ru.bgcrm.model.Page;
import ru.bgcrm.struts.form.DynActionForm;

public class Pageable<T> {
    private Page page = new Page();
    private final List<T> list = new ArrayList<T>();

    public Pageable() {
    }

    public Pageable(int pageSize) {
        this.page.setPageSize(pageSize);
    }

    public Pageable(DynActionForm form, int defaultPageSize) {
        this.page = form.getPage();
        if (this.page.isPaginationEnabled() && this.page.getPageSize() <= 0) {
            String key = "pageSize." + form.getPageableId();
            if (form.getUser() != null) {
                this.page.setPageSize(form.getUser().getPers().getInt(key, defaultPageSize));
            }
        }
        form.getResponse().addPageable(this);
    }

    public Pageable(DynActionForm form) {
        this(form, 25);
    }

    public Pageable<T> withoutPagination() {
        this.page.setPageIndex(Page.PAGE_INDEX_NO_PAGING);
        return this;
    }

    @Dynamic
    public Page getPage() {
        return this.page;
    }

    @Dynamic
    public List<T> getList() {
        return this.list;
    }

    public void add(T item) {
        this.list.add(item);
    }
}

