/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.servlet.user;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.event.iface.EventListener;
import org.bgerp.app.servlet.user.UserSession;
import org.bgerp.app.servlet.user.event.UserSessionClosedEvent;
import org.bgerp.app.servlet.user.event.UserSessionCreatedEvent;
import org.bgerp.cache.UserCache;
import org.bgerp.util.Log;
import ru.bgcrm.event.SetupChangedEvent;
import ru.bgcrm.model.user.User;
import ru.bgcrm.util.Utils;

public class LoginStat {
    private static final Log log = Log.getLog();
    private static LoginStat instance;
    private volatile long sessionTimeout = 0L;
    private final Map<String, UserSession> sessionMap = Collections.synchronizedMap(new LinkedHashMap());
    private volatile List<Integer> loggedUserIds = List.of();

    public static LoginStat instance() {
        if (instance == null) {
            instance = new LoginStat();
        }
        return instance;
    }

    private LoginStat() {
        try {
            EventListener<SetupChangedEvent> changeListener = (e, conSet) -> {
                this.sessionTimeout = Setup.getSetup().getSokLong(300L, "user.session.timeout", "sessionTimeout") * 1000L;
                log.debug("sessionTimeout: {}", this.sessionTimeout);
            };
            changeListener.notify(null, null);
            EventProcessor.subscribe(changeListener, SetupChangedEvent.class);
        }
        catch (Exception e2) {
            log.error(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userLoggedIn(HttpSession session, User user, String ip) {
        Map<String, UserSession> map = this.sessionMap;
        synchronized (map) {
            if (session != null && user != null) {
                UserSession userSession = new UserSession(session, user, ip);
                this.sessionMap.put(session.getId(), userSession);
                this.updateUserLoggedList();
                try {
                    EventProcessor.processEvent(new UserSessionCreatedEvent(userSession), null);
                }
                catch (Exception e) {
                    log.error(e);
                }
                log.debug("User logged: {}; userList size: {}; session: {}", user, this.loggedUserIds.size(), session.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(HttpSession session) {
        Map<String, UserSession> map = this.sessionMap;
        synchronized (map) {
            if (this.sessionMap != null && session != null) {
                UserSession userSession = this.sessionMap.remove(session.getId());
                this.updateUserLoggedList();
                if (userSession != null) {
                    try {
                        EventProcessor.processEvent(new UserSessionClosedEvent(userSession), null);
                    }
                    catch (Exception e) {
                        log.error(e);
                    }
                    log.debug("User session closed: {}; userList size: {}", userSession.user, this.loggedUserIds.size());
                }
            }
        }
    }

    private void updateUserLoggedList() {
        this.loggedUserIds = this.sessionMap.values().stream().map(session -> session.getUser().getId()).toList();
    }

    public void actionWasCalled(HttpSession session) {
        UserSession data = this.sessionMap.get(session.getId());
        if (data != null) {
            data.lastActive = System.currentTimeMillis();
        }
    }

    public boolean isSessionValid(HttpSession session) {
        UserSession data;
        if (this.sessionTimeout > 0L && (data = this.sessionMap.get(session.getId())) != null && data.lastActive + this.sessionTimeout < System.currentTimeMillis()) {
            log.debug("User session invalidated by timeout: {}; userList size: {}", data.user, this.loggedUserIds.size());
            return false;
        }
        return true;
    }

    public List<User> loggedUsers() {
        return Utils.getObjectList(UserCache.getUserMap(), this.loggedUserIds);
    }

    public LinkedHashMap<User, List<UserSession>> loggedUsersWithSessions() {
        LinkedHashMap<User, List<UserSession>> result = new LinkedHashMap<User, List<UserSession>>();
        for (UserSession data : this.sessionMap.values()) {
            User user = data.user;
            List<UserSession> userSessions = result.get(user);
            if (userSessions == null) {
                userSessions = new ArrayList<UserSession>();
                result.put(user, userSessions);
            }
            userSessions.add(data);
        }
        return result;
    }
}

