/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.util.inet;

import java.math.BigInteger;
import ru.bgcrm.util.inet.IpAddress;

public class IpNet {
    protected byte[] subnet;
    protected int mask;

    public IpNet() {
    }

    public IpNet(byte[] subnet, int mask) {
        this.subnet = subnet;
        this.mask = mask;
    }

    public byte[] getSubnet() {
        return this.subnet;
    }

    public void setSubnet(byte[] subnet) {
        this.subnet = subnet;
    }

    public int getMask() {
        return this.mask;
    }

    public void setMask(int mask) {
        this.mask = mask;
    }

    public String toString() {
        return IpNet.toString(this.subnet, this.mask);
    }

    public static String toString(byte[] subnet, int mask) {
        StringBuilder sb = new StringBuilder(subnet != null ? subnet.length * 3 + 4 : 32);
        return sb.append(IpAddress.toString(subnet)).append('/').append(mask).toString();
    }

    public static String toString(byte[] addressFrom, byte[] addressTo) {
        int mask = addressTo != null ? IpNet.getMask0(addressFrom, addressTo) : addressFrom.length * 8;
        StringBuilder sb = new StringBuilder(addressFrom != null ? addressFrom.length * 3 + 4 : 32);
        IpAddress.toString(addressFrom, sb);
        return sb.append('/').append(mask).toString();
    }

    public static int maskToInt(byte[] mask) {
        int result = 0;
        for (int i = mask.length - 1; i >= 0; --i) {
            int num = Integer.numberOfTrailingZeros(mask[i]);
            if (num >= 8) {
                result += 8;
                continue;
            }
            result += num;
            break;
        }
        return result;
    }

    public byte[] getMaxIp() {
        int i;
        byte[] addressTo = new byte[this.subnet.length];
        System.arraycopy(this.subnet, 0, addressTo, 0, this.subnet.length);
        for (i = this.subnet.length - 1; i > this.mask / 8; --i) {
            addressTo[i] = -1;
        }
        if (this.mask % 8 != 0) {
            int n = i;
            addressTo[n] = (byte)(addressTo[n] | (byte)(255 >> this.mask % 8));
        } else if (this.mask / 8 == 4) {
            int n = i;
            addressTo[n] = (byte)(addressTo[n] | 0);
        } else {
            int n = i;
            addressTo[n] = (byte)(addressTo[n] | (byte)(255 >> this.mask % 8));
        }
        return addressTo;
    }

    public static int getMask(byte[] addrFrom, byte[] addrTo) {
        BigInteger from = IpAddress.convertIp4AddresToBigInt(addrFrom);
        BigInteger to = IpAddress.convertIp4AddresToBigInt(addrTo);
        BigInteger addXor = from.xor(to);
        int n = 0;
        while (!addXor.equals(BigInteger.ZERO)) {
            addXor = addXor.shiftRight(1);
            ++n;
        }
        return 32 - n;
    }

    private static int getMask0(byte[] addressFrom, byte[] addressTo) {
        assert (addressFrom.length == addressTo.length);
        int size = addressFrom.length;
        for (int i = 0; i < size; ++i) {
            if (addressFrom[i] == addressTo[i]) continue;
            return i * 8 + (Integer.numberOfLeadingZeros(addressFrom[i] & 0xFF ^ addressTo[i] & 0xFF) - 24);
        }
        return size * 8;
    }

    public static IpNet newInstance(byte[] addressFrom, byte[] addressTo) {
        int mask = addressTo != null ? IpNet.getMask0(addressFrom, addressTo) : addressFrom.length * 8;
        return new IpNet(addressFrom, mask);
    }

    public boolean inNet(byte[] address) {
        return IpNet.inNet(address, this.subnet, this.mask);
    }

    public static boolean inNet(byte[] address, byte[] subnet, int mask) {
        if (mask == 0) {
            return true;
        }
        int end = mask / 8;
        int i = end - 1;
        if (i < 0) {
            int remainder = mask;
            if (Integer.numberOfLeadingZeros(address[end] & 0xFF ^ subnet[end] & 0xFF) - 24 < remainder) {
                return false;
            }
        } else {
            int remainder;
            if (address[i] != subnet[i]) {
                return false;
            }
            if (end < subnet.length && (remainder = mask % 8) > 0 && Integer.numberOfLeadingZeros(address[end] & 0xFF ^ subnet[end] & 0xFF) - 24 < remainder) {
                return false;
            }
            --i;
            while (i >= 0) {
                if (address[i] != subnet[i]) {
                    return false;
                }
                --i;
            }
        }
        return true;
    }
}

