/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.servlet.filter;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.l10n.Localization;
import org.bgerp.app.l10n.Localizer;
import org.bgerp.app.servlet.Interface;
import org.bgerp.app.servlet.filter.AuthFilter;
import org.bgerp.app.servlet.jsp.UiFunction;
import org.bgerp.app.servlet.util.ServletUtils;
import org.bgerp.cache.CustomerGroupCache;
import org.bgerp.cache.ParameterCache;
import org.bgerp.cache.ProcessQueueCache;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.cache.UserCache;
import org.bgerp.cache.UserGroupRoleCache;
import org.bgerp.dao.expression.Expression;
import org.bgerp.util.Log;
import org.bgerp.util.sql.pool.ConnectionPool;
import ru.bgcrm.plugin.PluginManager;

public class SetRequestParamsFilter
implements Filter {
    public static final String REQUEST_KEY_LOCALIZER = "l";

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Map<String, Object> variables = SetRequestParamsFilter.getContextVariables((HttpServletRequest)request);
        Expression.setExpressionContextUtils(variables);
        for (Map.Entry<String, Object> me : variables.entrySet()) {
            request.setAttribute(me.getKey(), me.getValue());
        }
        if (!ServletUtils.getRequestURI((HttpServletRequest)request).endsWith(".jsp") || "usermob".equals(Interface.getIface((HttpServletRequest)request))) {
            request.setAttribute(REQUEST_KEY_LOCALIZER, (Object)this.getLocalizer(request));
        }
        request.setAttribute("ui", (Object)UiFunction.INSTANCE);
        request.setAttribute("log", (Object)JSP.log);
        chain.doFilter(request, response);
    }

    private Localizer getLocalizer(ServletRequest request) {
        Localizer result = Localization.getLocalizer((HttpServletRequest)request);
        if (result == null) {
            result = Localization.getLocalizer();
        }
        return result;
    }

    public static Map<String, Object> getContextVariables(HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>(30);
        result.put("ctxSetup", Setup.getSetup());
        result.put("ctxCustomerGroupMap", CustomerGroupCache.getGroupMap());
        result.put("ctxCustomerGroupList", CustomerGroupCache.getGroupList());
        if (request != null) {
            result.put("ctxUser", AuthFilter.getUser(request));
            result.put("ctxIface", Interface.getIface(request));
        }
        result.put("ctxPluginManager", PluginManager.getInstance());
        result.put("ctxUserCache", UserCache.HOLDER.getInstance());
        result.put("ctxUserList", UserCache.getUserList());
        result.put("ctxUserMap", UserCache.getUserMap());
        result.put("ctxUserGroupRoleList", UserGroupRoleCache.getUserGroupRoleList());
        result.put("ctxUserGroupRoleMap", UserGroupRoleCache.getUserGroupRoleMap());
        result.put("ctxUserGroupList", UserCache.getUserGroupList());
        result.put("ctxUserGroupMap", UserCache.getUserGroupMap());
        result.put("ctxUserGroupFullTitledList", UserCache.getUserGroupFullTitledList());
        result.put("ctxUserGroupFullTitledMap", UserCache.getUserGroupFullTitledMap());
        result.put("ctxUserPermsetList", UserCache.getUserPermsetList());
        result.put("ctxUserPermsetMap", UserCache.getUserPermsetMap());
        ConnectionPool connectionPool = Setup.getSetup().getConnectionPool();
        result.put("ctxDataSource", connectionPool.getDataSource());
        result.put("ctxSlaveDataSource", connectionPool.getSlaveDataSource());
        result.put("ctxProcessTypeMap", ProcessTypeCache.getProcessTypeMap());
        result.put("ctxProcessTypeTreeRoot", ProcessTypeCache.getTypeTreeRoot());
        result.put("ctxProcessStatusList", ProcessTypeCache.getStatusList());
        result.put("ctxProcessStatusMap", ProcessTypeCache.getStatusMap());
        result.put("ctxProcessQueueMap", ProcessQueueCache.getQueueMap());
        result.put("ctxProcessQueueList", ProcessQueueCache.getQueueList());
        result.put("ctxParameterCache", ParameterCache.HOLDER.getInstance());
        result.put("ctxParameterMap", ParameterCache.getParameterMap());
        return result;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private static final class JSP {
        private static final Log log = Log.getLog();

        private JSP() {
        }
    }
}

